; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-Layer ) 
	(gimp-message  "Layer")
	
)
;--------------------------------------------------レイヤー?
(define ( MSK-isLayer layerID ) 
	(gimp-drawable-is-layer layerID)
)
;--------------------------------------------------フローター?
(define ( MSK-isFloatingSel layerID ) 
	(gimp-layer-is-floating-sel layerID)
)
;--------------------------------------------------フローター?ならレイヤーに転換
(define ( MSK-convertFloatingSel2Layer layerID ) 
	(if ( MSK-isFloatingSel layerID ) 
		(gimp-floating-sel-to-layer layerID)
	)
)
;--------------------------------------------------四捨五入：桁溢れが気になる
(define ( MSK-Layer fileName levelInput) 
	(let* (
			(i 0)
		)
	)
)
;--------------------------------------------------LayerIDからImageIDの逆引き
(define ( MSK-getImageIDByLayerID layerID ) 
	(let* (
			(imageIDList (vector->list(MSK-getValueByIndex (gimp-image-list)1) ))
			(imageIDCount (MSK-count imageIDList))
			(resultImageID -1)
			(currentImageID -1)
		)
        (while (> imageIDCount 0)
        	(set! currentImageID (MSK-getValueByIndex imageIDList (- imageIDCount 1)))
        	(if (eqv? (MSK-hasTheLayerOnImage currentImageID layerID) 1)
        		(begin 
        			(set! resultImageID currentImageID )
        			(set! imageIDCount 0)
        		)
        	)
            (set! imageIDCount (- imageIDCount 1))
        )
        resultImageID
	)
)
;--------------------------------------------------対象のイメージに指定のレイヤーがあるか判定
(define ( MSK-hasTheLayerOnImage imageID layerID) 
	(MSK-hasElement ( MSK-getLayersIDList imageID ) layerID)
)

;--------------------------------------------------サイズが同じRGBの乗算レイヤーを作成
(define ( MSK-newLayer imageID ) 
	(let* (
			(newLayer 0)
		)
		(set! newLayer (MSK-getValueByIndex (gimp-layer-new imageID 1 1  1 "new layer" 100 3 ) 0))
		(gimp-image-add-layer imageID newLayer -1)
		(gimp-layer-resize-to-image-size newLayer)
		(gimp-drawable-fill newLayer BACKGROUND-FILL)
		newLayer
	)
)
;--------------------------------------------------レイヤーを削除
(define ( MSK-deleteLayer layerID ) 
	;(MSK-first(gimp-layer-delete layerID))
	(gimp-image-remove-layer ( MSK-getImageIDByLayerID layerID ) layerID)
)
;--------------------------------------------------レイヤーをコピー
(define ( MSK-copyLayer  layerID ) 
	(let* (
			(newLayer 0)
		)
		(set! newLayer (MSK-first(gimp-layer-copy layerID FALSE)))
		(gimp-image-add-layer ( MSK-getImageIDByLayerID layerID ) newLayer -1)
		newLayer
	)
)
;--------------------------------------------------レイヤーを別の画像にコピー
(define ( MSK-copyLayerToTheImage imageID layerID ) 
	(let* (
			(newImageID ( MSK-copyImage ( MSK-getImageIDByLayerID layerID ) ))
			(layerName ( MSK-getLayerName layerID ))
			(newLayer (MSK-getLayerIDByName newImageID layerName))
			(copyLayer 0)
			(tempImageFileName "test.png")
		)
		(MSK-deleteLayerNoIDOnTheList newImageID (list newLayer))
		( MSK-saveImageByExt newImageID tempImageFileName) 
		(set! copyLayer ( MSK-loadAsLayer tempImageFileName imageID) )
		(gimp-image-delete newImageID)
		( MSK-setLayerName copyLayer layerName) 
		( MSK-setOpacityLayer copyLayer ( MSK-getOpacityLayer layerID) )
		( MSK-setModeLayer copyLayer  ( MSK-getModeLayer layerID) )
		copyLayer
	)
)
;--------------------------------------------------レイヤーをイメージ間移動
(define ( MSK-moveLayer newImageID layerID ) 
	(let* (
			(newLayer 0)
		)
		(set! newLayer ( MSK-copyLayerToTheImage newImageID layerID ) )
		( MSK-deleteLayer layerID )
		newLayer
	)
)
;--------------------------------------------------レイヤーをイメージからロード
(define ( MSK-loadAsLayer fileName newImageID) 
	(let* (
			(newLayer (MSK-first(vector->list(MSK-getValueByIndex(gimp-file-load-layers 1 newImageID fileName ) 1))))
		)
		(gimp-image-add-layer newImageID newLayer -1)
		( MSK-setLayerName newLayer "loadLayer") 
		newLayer
	)
)
;--------------------------------------------------名前取得
(define ( MSK-getLayerName layerID ) 
	(MSK-first(gimp-layer-get-name layerID ))
)
;--------------------------------------------------名前からID取得
(define ( MSK-getLayerIDByName imageID name) 
	(let* (
			(resultLayerID -1)
			(layerIDList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDList ))
			(currentLayerName "")
			(currentLayerID "")
			(resultLayerID "")
		)
        (while (> layerCount 0)
        	(set! currentLayerID (MSK-getValueByIndex layerIDList (- layerCount 1)))
        	(set! currentLayerName ( MSK-getLayerName currentLayerID ))
            (if(equal? currentLayerName name)
            	(begin 
            		(set! layerCount 0)
            		(set! resultLayerID currentLayerID)
            	)
            )
            (set! layerCount (- layerCount 1))
        )
        resultLayerID
	)
)
;--------------------------------------------------名前設定
(define ( MSK-setLayerName layerID newName) 
	(MSK-first(gimp-layer-set-name layerID newName))
)
;--------------------------------------------------付透明度取得
(define ( MSK-getModeLayer layerID) 
	(MSK-first(gimp-layer-get-mode layerID))
)
;--------------------------------------------------付透明度設定
(define ( MSK-setModeLayer layerID mode) 
	(MSK-first(gimp-layer-set-mode layerID mode))
)
;--------------------------------------------------付透明度取得
(define ( MSK-getOpacityLayer layerID) 
	(MSK-first(gimp-layer-get-opacity layerID))
)
;--------------------------------------------------付透明度設定
(define ( MSK-setOpacityLayer layerID opacity) 
	(MSK-first(gimp-layer-set-opacity layerID opacity))
)
;--------------------------------------------------最上部に設定
(define ( MSK-topZindexLayer layerID ) 
	(MSK-first(gimp-image-raise-layer-to-top ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------最上部に設定
(define ( MSK-bottomZindexLayer layerID ) 
	(MSK-first(gimp-image-lower-layer-to-bottom ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------一つ上に設定する
(define ( MSK-upZindexLayer layerID ) 
	(MSK-first(gimp-image-raise-layer ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------一つ下に設定する
(define ( MSK-downZindexLayer layerID ) 
	(MSK-first(gimp-image-lower-layer ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------現在のレイヤーの位置を取得(0始まり上からの順番)
(define ( MSK-getZindexLayer  layerID ) 
	(MSK-first(gimp-image-get-layer-position ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------レイヤーのIDリストゲット
(define ( MSK-getLayersIDListSortedByZindex imageID ) 
	(vector->list(MSK-getValueByIndex (gimp-image-get-layers imageID ) 1))
)
;--------------------------------------------------レイヤーのIDリストゲットこれは既に上からの順番で出力される。
(define ( MSK-getLayersIDList imageID ) 
	(vector->list(MSK-getValueByIndex (gimp-image-get-layers imageID ) 1))
)
;--------------------------------------------------レイヤーのIDリスト順にレイヤーをソート
(define ( MSK-sortLayerZindexByNameList imageID layerNameList ) 
	(let* (
			(resultLayerID -1)
			(layerIDList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDList ))
			(nameCount ( MSK-count layerNameList ))
			(currentLayerName "")
			(currentLayerID "")
			(resultLayerID "")
			(currentName "")
			(resultNotMatchLayerID ())
		)
		(set! layerCountAll  layerCount)
        (while (> nameCount 0)
			(set! currentName (MSK-getValueByIndex layerNameList (- nameCount 1)))
		    (while (> layerCount 0)
		    	(set! currentLayerID (MSK-getValueByIndex layerIDList (- layerCount 1)))
		    	(set! currentLayerName ( MSK-getLayerName currentLayerID ))
		        (if(equal? currentLayerName currentName)
		        	(begin 
		        		(set! layerCount 0)
		        		(MSK-topZindexLayer currentLayerID ) 
		        	)
		        )
		        (set! layerCount (- layerCount 1))
		    )
			(set! layerCount  layerCountAll)
			(set! nameCount (- nameCount 1))
        )
	)
)
;--------------------------------------------------レイヤーのIDリストにないレイヤーを削除
(define ( MSK-deleteLayerNoNameOnTheList imageID layerNameList ) 
	(let* (
			(resultLayerID -1)
			(layerIDList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDList ))
			(nameCount ( MSK-count layerNameList ))
			(currentLayerName "")
			(currentLayerID "")
			(resultLayerID "")
			(currentName "")
			(resultNotMatchLayerID ())
			(delFlag 2)
			(layerCountAll 0)
		)
		(set! layerCountAll  nameCount)
	    (while (> layerCount 0)
	    	(set! delFlag 2)
	    	(set! currentLayerID (MSK-getValueByIndex layerIDList (- layerCount 1)))
	    	(set! currentLayerName ( MSK-getLayerName currentLayerID ))
	    	
		    (while (> nameCount 0)
				(set! currentName (MSK-getValueByIndex layerNameList (- nameCount 1)))
			    (if(equal? currentLayerName currentName)
			    	(begin 
			    		(set! nameCount 0)
			    		(set! delFlag FALSE)
			    	)
			    )
				(set! nameCount (- nameCount 1))
		    )
		    (if (eqv? delFlag 2)
		    	(MSK-deleteLayer currentLayerID)
		    )
			(set! nameCount  layerCountAll)
	        (set! layerCount (- layerCount 1))
	    )
	    delFlag
	)
)
;--------------------------------------------------レイヤーのIDリストにないレイヤーを削除
(define ( MSK-deleteLayerNoIDOnTheList imageID layerIDList ) 
	(let* (
			(resultLayerID -1)
			(layerIDALLList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDALLList ))
			(IDCount ( MSK-count layerIDList ))
			(currentLayerID "")
			(resultLayerID "")
			(currentID "")
			(resultNotMatchLayerID ())
			(delFlag 2)
			(layerCountAll 0)
		)
		(set! layerCountAll IDCount)
	    (while (> layerCount 0)
	    	(set! delFlag 2)
	    	(set! currentLayerID (MSK-getValueByIndex layerIDALLList (- layerCount 1)))
	    	
		    (while (> IDCount 0)
				(set! currentID (MSK-getValueByIndex layerIDList (- IDCount 1)))
			    (if(eqv? currentLayerID currentID)
			    	(begin 
			    		(set! IDCount 0)
			    		(set! delFlag 0)
			    	)
			    )
				(set! IDCount (- IDCount 1))
		    )
		    (if (eqv? delFlag 2)
		    	(MSK-deleteLayer currentLayerID)
		    )
			(set! IDCount  layerCountAll)
	        (set! layerCount (- layerCount 1))
	    )
	    delFlag
	)
)
;--------------------------------------------------レイヤー数ゲット
(define ( MSK-getLayersCount imageID ) 
	(MSK-first (gimp-image-get-layers imageID ) )
)
;--------------------------------------------------レイヤー幅ゲット
(define ( MSK-getLayerWidth  layerID)　
	(MSK-first (gimp-drawable-width layerID))
)
;--------------------------------------------------レイヤー高さゲット
(define ( MSK-getLayerHeight layerID) 
	(MSK-first (gimp-drawable-height layerID))
)
;--------------------------------------------------レイヤー幅セット
(define ( MSK-setLayerWidth  layerID newWidth) 
	(gimp-layer-resize layerID
		newWidth
		( MSK-getLayerHeight layerID) 
		( MSK-getOffsetX  layerID)
		( MSK-getOffsetY  layerID)
	)
)
;--------------------------------------------------レイヤー高さセット
(define ( MSK-setLayerHeight layerID newHeight) 
	(gimp-layer-resize layerID
		( MSK-getLayerWidth layerID) 
		newHeight
		( MSK-getOffsetX  layerID)
		( MSK-getOffsetY  layerID)
	)
)
;--------------------------------------------------レイヤーoffsetX
(define ( MSK-getOffsetX  layerID) 
	(MSK-getValueByIndex (gimp-drawable-offsets layerID) 0)
)
;--------------------------------------------------レイヤーoffsetY
(define ( MSK-getOffsetY  layerID) 
	(MSK-getValueByIndex (gimp-drawable-offsets layerID) 1)
)
;--------------------------------------------------レイヤーoffsetX設定
(define ( MSK-setOffsetX  layerID newOffsetX) 
	(gimp-layer-set-offsets layerID newOffsetX ( MSK-getOffsetY layerID))
)
;--------------------------------------------------レイヤーoffsetY設定
(define ( MSK-setOffsetY  layerID newOffsetY) 
	(gimp-layer-set-offsets layerID ( MSK-getOffsetX layerID) newOffsetY)
)
;--------------------------------------------------レイヤー幅セット
(define ( MSK-scaleLayer  layerID newScale) 
	(gimp-layer-scale layerID
		(* ( MSK-getLayerWidth layerID) newScale) 
		(* ( MSK-getLayerHeight layerID) newScale) 
		TRUE
	)
)
;--------------------------------------------------レイヤー見えてる？
(define ( MSK-isVisibleLayer  layerID) 
	(MSK-first (gimp-layer-get-visible layerID))
)
;--------------------------------------------------レイヤー見える設定
(define ( MSK-setInvisibleLayer  layerID) 
	(MSK-first (gimp-layer-set-visible layerID TRUE))
)
;--------------------------------------------------レイヤー見えない設定
(define ( MSK-setVisibleLayer  layerID) 
	(MSK-first (gimp-layer-set-visible layerID FALSE))
)
;--------------------------------------------------レイヤーロックしてる？
(define ( MSK-isLockedLayer  layerID) 
	(MSK-first (gimp-layer-get-linked layerID))
)
;--------------------------------------------------レイヤーロック設定
(define ( MSK-setLockLayer  layerID) 
	(MSK-first (gimp-layer-set-linked layerID TRUE))
)
;--------------------------------------------------レイヤーロックしない設定
(define ( MSK-setUnLockLayer  layerID) 
	(MSK-first (gimp-layer-set-linked layerID FALSE))
)
;--------------------------------------------------レイヤーに色をつける
(define ( MSK-fillLayerColor  layerID color) 
	(let* (
			(currentBackground (MSK-first(gimp-context-get-background)))
		)
		(gimp-context-set-background color)
		(gimp-drawable-fill layerID BACKGROUND-FILL)
		(gimp-context-set-background currentBackground)
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-Layer"
		    "Mansiki-Layer(Lib)"
		    "Mansiki"
		    "name"
		    "Rongfu"
		    "2008/06/09"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-Layer"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
