; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-Time ) 
	(gimp-message  "Time")
	
)
;--------------------------------------------------現在時間の取得
(define ( MSK-getNowTime ) 
    (MSK-secToDateList  (realtime))
)
;--------------------------------------------------現在時間の取得(YYYY-MM-DD hh:mm:ss)
(define ( MSK-getNowDateTime ) 
    (MSK-convertdateListToDateTime (MSK-secToDateList (realtime)))
)
;--------------------------------------------------1970/01/01 00:00:00からの絶対秒数から現在の日時（東京時間）を取得
(define ( MSK-secToDateList totalSec ) 
	(let* (
			(realTimeValue totalSec)
			;(unitSec 60)
			(unitMin 60)
			(unitHour (* unitMin 60))
			(unitDay (* unitHour 24))
			(unitMonth (* unitDay 24))
			(unitYear (* unitDay 365) )
			(retDay 0)
			(tempDay (trunc (/ realTimeValue unitDay)))
			(retMonth 0)
			(retYear 0)
			(tempYear (+ (trunc (/ tempDay 365)) 1970))
			(tempDay2 (MSK-mod tempDay 365))
			(tempDay3 0)
			(totalDaysOfYearAtPreMonth 0)
			(countDay 0)
			(monthCount 0)
			(GreenwichOffset 9);グリニッジ天文台時間からの差分
			(retSec (MSK-mod realTimeValue 60))
			(retMin (MSK-mod (trunc (/ realTimeValue unitMin)) 60))
			(retHour (+ (MSK-mod (trunc (/ realTimeValue unitHour)) 24) GreenwichOffset))
			(daysOfMonth2 28 )
			(daysOfMonth 31 )
		)
		(set! tempDay2 (+ (- tempDay2 (trunc (/ (- tempYear 1968) 4))) 1))
		(if (< tempDay2 1)
		    (begin
		        (set! tempYear(- tempYear 1))
		        (if(eqv? (MSK-mod tempYear 4) 0)   ;閏年の場合
		            (set! tempDay2(- 366 tempDay2))
		            (set! tempDay2(- 365 tempDay2))
		        )
		    )
		)
		
		(set! tempDay3 tempDay2)
		
		(if (eqv? (MSK-mod tempYear 4) 0)   ;閏年の場合
		    (set! daysOfMonth2 29)
		)
		
		(while (< countDay  tempDay3)
		    (set! monthCount (+ monthCount 1))
		    (set! totalDaysOfYearAtPreMonth (+ countDay 0))
            (set! daysOfMonth (MSK-getDayNumAtMonth tempYear monthCount ))
		    (set! countDay (+ countDay daysOfMonth))
		)
		
		(set! retMonth monthCount)
		(set! retYear tempYear)
		(set! retDay (- tempDay3 totalDaysOfYearAtPreMonth))

		 ( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
		;(list retYear retMonth retDay retHour retMin retSec)
	)
)
;--------------------------------------------------正確な時間に変換
(define ( MSK-setValidDateList dateList ) 
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
			(daysOfMonth (MSK-getDayNumAtMonth retYear retMonth ))
			(countDay 0)
			(yareOffset 0)
			(monthOffset 0)
			(totalDaysOfYearAtPreMonth 0)
		)
		(if(<= 60 retSec )
		    (begin 
		        (set! retMin (+ retMin (trunc (/ retSec 60))))
		        (set! retSec (MSK-mod retSec 60))
		    )
		)
		(if(<= retSec -1)
		    (begin 
		        (set! retMin (+ retMin (trunc (/ retSec 60))))
		        (set! retMin (- retMin 1))
		        (set! retSec (- 60 (MSK-mod retSec 60)))
		    )
		)
		
		(if(<= 60 retMin )
		    (begin 
		        (set! retHour (+ retHour  (trunc (/ retMin 60))))
		        (set! retMin (MSK-mod retMin 60))
		    )
		)
		(if(<= retMin -1)
		    (begin 
		        (set! retHour (+ retHour  (trunc (/ retMin 60))))
		        (set! retHour (- retHour 1))
		        (set! retMin (- 60 (MSK-mod retMin 60)))
		    )
		)
		
		(if(<= 24 retHour )
		    (begin 
		        (set! retDay (+ retDay (trunc (/ retHour 24))))
		        (set! retHour (MSK-mod retHour 24))
		    )
		)
		(if(<= retHour -1)
		    (begin 
		        (set! retDay (+ retDay (trunc (/ retHour 24))))
		        (set! retDay (- retDay 1))
		        (set! retHour (- 24 (MSK-mod retHour 24)))
		    )
		)
		
	    (set! daysOfMonth (MSK-getDayNumAtMonth retYear retMonth ))
		(if(< daysOfMonth retDay )
		    (begin 
		        (set! yareOffset (trunc (/ retDay 365)))
		        (set! retYear (+ retYear yareOffset))
		        (set! retDay (trunc (+ retDay (/ yareOffset 4))))
		        
		        (set! countDay daysOfMonth)
        		(set! monthOffset 0)
        		(while (< countDay  retDay)
        		    (set! totalDaysOfYearAtPreMonth  countDay)
                    (set! daysOfMonth (MSK-getDayNumAtMonth retYear (+ retMonth monthOffset) ))
        		    (set! monthOffset (+ monthOffset 1))
        		    (set! countDay (+ countDay daysOfMonth))
        		)
		        (set! retDay (- retDay totalDaysOfYearAtPreMonth))
		        (set! retMonth (+ retMonth monthOffset))
		    )
		)
		(if(<= retDay 0 )
		    (begin 
   		        (set! yareOffset (trunc (/ retDay 365)))
		        (set! retYear (+ retYear yareOffset))
		        (set! retDay (trunc (+ retDay  (/ yareOffset 4))))
                (set! monthOffset -1)
                (set! daysOfMonth (MSK-getDayNumAtMonth retYear (- retMonth (trunc (+ 1 (/ retDay 30))) )))
        		(if(eqv? 0 retDay )
        		    (set! retMonth daysOfMonth)
		            (begin 
        		        (set! countDay (* -1 daysOfMonth))
                		(set! totalDaysOfYearAtPreMonth  countDay)
                		(while (< retDay countDay )
                            (set! daysOfMonth (MSK-getDayNumAtMonth retYear (+ retMonth monthOffset) ))
                		    (set! monthOffset (- monthOffset 1))
                		    (set! countDay (+ countDay daysOfMonth))
                		    (set! totalDaysOfYearAtPreMonth  countDay)
                		)
        		        (set! retDay (- retDay totalDaysOfYearAtPreMonth))
        		        (set! retMonth (+ retMonth monthOffset))
        		    )
        		)
        	)
		)
		(if(eqv? 0 retMonth )
		    (set! retMonth 12)
		)
		(if(< 12 retMonth )
		    (begin 
		        (set! retYear (+ retYear (trunc (/ retMonth 12))))
		        (set! retMonth (MSK-mod retMonth 12))
		    )
		)
		(if(<= retMonth -1)
		    (begin 
		        (set! retYear (+ retYear (trunc (/ retMonth 12))))
		        (set! retYear (- retYear 1))
		        (set! retMonth (+ 12 (MSK-mod retMonth 12)))
		    )
		)
		(list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec))
	)
)
;--------------------------------------------------その年のその月の最大日数を取得
(define ( MSK-getDayNumAtMonth year mon ) 
	(let* (
	        (daysOfMonth 31)
	        (month (MSK-mod mon 12))
	        (tempYear year)
		)
		(if (< mon 0)
		    (begin 
		        (set! month (* -1 (- month 12)))
		        (set! tempYear (- tempYear 1))
		   )
		)
	    (cond ((or (eqv? month 1 ) (eqv? month 3 ) (eqv? month 5 ) (eqv? month 7 ) (eqv? month 8 ) (eqv? month 10 ) (eqv? month 12 ))
	                (set! daysOfMonth 31)
	            )
	            ((or (eqv? month 4 ) (eqv? month 6 ) (eqv? month 9 ) (eqv? month 11 ))
	                (set! daysOfMonth 30)
	            )
	            ((eqv? month 2 ) 
		            (if(eqv? (MSK-mod tempYear 4) 0)   ;閏年の場合
    	                (set! daysOfMonth 29)
    	                (set! daysOfMonth 28)
	                )
	            )
	    )
	    daysOfMonth
	)
)
;--------------------------------------------------DateTimeからリスト形式に変換
(define ( MSK-convertDateTimeToDateList string ) 
	(let* (
			(retYear   0)
			(retMonth  0)
			(retDay    0)
			(retHour   0)
			(retMin    0)
			(retSec    0)
			(tempDateList (list ""))
			(tempString "")
			(listLen 0)
		)
		(set! tempString (MSK-replace string ":" "-"))
		(set! tempString (MSK-replace tempString " " "-"))
		(set! tempString (MSK-replace tempString "--" "-"))
		(set! tempDateList (append tempDateList (MSK-split tempString "-")))
		(set! tempDateList (MSK-shift tempDateList))
		(set! listLen (length tempDateList))
		(if (> listLen 0)
		    (set! retYear    (string->number (MSK-getValueByIndex tempDateList 0)))
		    (set! retYear   1970)
		)
		(if (> listLen 1)
		    (set! retMonth  (string->number (MSK-getValueByIndex tempDateList 1)))
		    (set! retMonth  1)
		)
		(if (> listLen 2)
		    (set! retDay    (string->number (MSK-getValueByIndex tempDateList 2)))
		    (set! retDay    1)
		)
		(if (> listLen 3)
		    (set! retHour   (string->number (MSK-getValueByIndex tempDateList 3)))
		    (set! retHour    0)
		)
		(if (> listLen 4)
		    (set! retMin   (string->number (MSK-getValueByIndex tempDateList 4)))
		    (set! retMin    0)
		)
		(if (> listLen 5)
		    (set! retSec    (string->number (MSK-getValueByIndex tempDateList 5)))
		    (set! retSec    0)
		)
		
		( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
	)
)
;--------------------------------------------------リスト形式からDateTimeに変換
(define ( MSK-convertdateListToDateTime dateList ) 
	(let* (
			(retYear    ( MSK-getValueByIndex dateList 0))
			(retMonth   ( MSK-getValueByIndex dateList 1))
			(retDay     ( MSK-getValueByIndex dateList 2))
			(retHour    ( MSK-getValueByIndex dateList 3))
			(retMin     ( MSK-getValueByIndex dateList 4))
			(retSec     ( MSK-getValueByIndex dateList 5))
			(tempDateList (list ""))
		)	
		(set! tempDateList (MSK-push tempDateList (MSK-getIntStrAt0Head (string->number retYear) 4) ))
		(set! tempDateList (MSK-push tempDateList  "-" ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retMonth) 2) ))
		(set! tempDateList (MSK-push tempDateList  "-" ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retDay ) 2) ))
		(set! tempDateList (MSK-push tempDateList  " " ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retHour) 2) ))
		(set! tempDateList (MSK-push tempDateList  ":" ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retMin ) 2) ))
		(set! tempDateList (MSK-push tempDateList   ":" ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retSec) 2) ))
		(MSK-join tempDateList "")
	)
)
;--------------------------------------------------リスト形式からStringに変換
(define ( MSK-convertdateListToString dateList resultLength) 
	(let* (
			(retYear    ( MSK-getValueByIndex dateList 0))
			(retMonth   ( MSK-getValueByIndex dateList 1))
			(retDay     ( MSK-getValueByIndex dateList 2))
			(retHour    ( MSK-getValueByIndex dateList 3))
			(retMin     ( MSK-getValueByIndex dateList 4))
			(retSec     ( MSK-getValueByIndex dateList 5))
			(tempDateList (list ""))
		)	
		(set! tempDateList (MSK-push tempDateList (MSK-getIntStrAt0Head (string->number retYear) 4) ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retMonth) 2) ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retDay ) 2) ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retHour) 2) ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retMin ) 2) ))
		(set! tempDateList (MSK-push tempDateList ( MSK-getIntStrAt0Head (string->number retSec) 2) ))
		(MSK-Left (MSK-join tempDateList "") resultLength)
	)
)
;--------------------------------------------------ツエラーの公式
(define ( MSK-getWeekDay dateList) 
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
			(tempW 0)
			(y 0)
			(h 0)
		)
		(if (or (eqv? retMonth 1) (eqv? retMonth 2))
		    (begin 
		        (set! retMonth (+ 12 retMonth))
		        (set! retYear (- retYear 1))
		    )
		)
		(set! y (- retYear 2000))
		(set! h (trunc (/ retYear 100)))
		
		(set! tempW (+ tempW retYear ))
		(set! tempW (+ tempW (trunc (/ retYear 4))))
		(set! tempW (+ tempW (trunc (/ retYear 400))))
		(set! tempW (- tempW (trunc (/ retYear 100))))
		(set! tempW (+ tempW (trunc (/ (+ (* 13 retMonth) 8 ) 5) ) ))
		(set! tempW (+ tempW retDay ))
		(trunc (MSK-mod tempW 7))
	)
)
;--------------------------------------------------datetime文字列形式に直接型指定で日付を修正
(define ( MSK-setDayAddAtDatetime Type datetime addInt) 
    ( MSK-convertdateListToDateTime( MSK-setDayAddAtDateList Type ( MSK-convertDateTimeToDateList datetime )addInt) )
)
;--------------------------------------------------datetimeリスト列形式に直接型指定で日付を修正
(define ( MSK-setDayAddAtDateList Type dateList addInt) 
	(let* (
			(tempDateList (list ""))
		)
		(set! tempDateList dateList )
		(cond ((or (equal? Type "year" ) (equal? Type "Y" ))
	                (set! tempDateList ( MSK-setYearAdd tempDateList addInt) )
	            )
	            ((or (equal? Type "mon" ) (equal? Type "M" ) (equal? Type "month" ))
	                (set! tempDateList ( MSK-setMonthAdd tempDateList addInt) )
	            )
	            ((or (equal? Type "day" ) (equal? Type "D" ))
	                (set! tempDateList ( MSK-setDayAdd tempDateList addInt) )
	            )
	            ((or (equal? Type "hour" ) (equal? Type "h" ))
	                (set! tempDateList ( MSK-setHourAdd tempDateList addInt) )
	            )
	            ((or (equal? Type "min" ) (equal? Type "m" )  (equal? Type "minut" ))
	                (set! tempDateList ( MSK-setMinutshAdd tempDateList addInt) )
	            )
	            ((or (equal? Type "sec" ) (equal? Type "s" )  (equal? Type "second" ))
	                (set! tempDateList ( MSK-setSecAdd tempDateList addInt) )
	            )
	    )
	    tempDateList
	)
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-setDayAdd dateList addInt) 
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
		)
		(set! retDay (+ addInt retDay))
		( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
	)
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-setMonthAdd dateList addInt) 
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
		)
		(set! retMonth (+ addInt retMonth))
		( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
		;(list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec))
	)
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-setYearAdd dateList addInt) 
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
		)
		(set! retYear (+ addInt retYear))
		( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
	)
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-setSecAdd dateList addInt) 
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
		)
		(set! retSec (+ addInt retSec))
		( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
	)
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-setMinutshAdd dateList addInt) 
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
		)
		(set! retMin (+ addInt retMin))
		( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
	)
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-setHourAdd dateList addInt)  
	(let* (
			(retYear    (string->number( MSK-getValueByIndex dateList 0)))
			(retMonth   (string->number( MSK-getValueByIndex dateList 1)))
			(retDay     (string->number( MSK-getValueByIndex dateList 2)))
			(retHour    (string->number( MSK-getValueByIndex dateList 3)))
			(retMin     (string->number( MSK-getValueByIndex dateList 4)))
			(retSec     (string->number( MSK-getValueByIndex dateList 5)))
		)
		(set! retHour (+ addInt retHour))
		( MSK-setValidDateList (list (number->string retYear) (number->string retMonth) (number->string retDay) (number->string retHour) (number->string retMin) (number->string retSec)))
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-Time"
		    "Mansiki-Time(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2007/05/27"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-Time"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
