; GIMP Script-Fu Mansiki Libs
;Tiny-fu版に変更
(define ( Mansiki-vector ) 
	(gimp-message  "vector lib")
)

;--------------------------------------------------

(define ( MSK-vectorAppend a b) 
	(let* (
			(countA 0)
			(countB 0)
			(result (vector ""))
			(current (vector ""))
			(count 0)
			(resultlength 0)
		)	
		(if (not (and (null? a) (null? a)))
		    (begin
		        (if (vector? a)
		            (set! countA (vector-length a))
		            (begin
		                (set! a (MSK-convert2Vector a))
		                (set! countA (vector-length a))
		            )
		        )
		        (if (vector? b)
		            (set! countB (vector-length b))
		            (begin
		                (set! b (MSK-convert2Vector b))
		                (set! countB (vector-length b))
		            )
		        )
		
		        (set! resultlength (+ countA countB))
		        (set! result (make-vector resultlength))
		        (while (< count resultlength)
		            (if (> countA count)
		                (begin 
		                    (set! current count)
		                    (set! result (vector-set! result current (vector-ref a current )))
		                )
		                (begin 
		                    (set! current (- count countA))
		                    (set! result (vector-set! result count (vector-ref b current )))
		                )
		             )
		            (set! count (+ count 1))
		        )
		    )
		    (begin 
		        (if (not(null? a))
		            (set! result (MSK-convert2Vector a))
		        )
		        (if (not(null? b))
		            (set! result (MSK-convert2Vector b))
		        )
		        (if (and (null? a) (null? b))
		            (set! result nil)
		        )
		    )
		)
		result
	)
)

;------------------------------------------------------

(define ( MSK-convert2Vector inputA ) 
    (let* (
	        (result "")
	       )
	       (if (vector? inputA)
	            (set! result inputA)
	            (begin
	                (if (list? inputA) (set! result ( MSK-list2Vector inputA )))
	                (if (string? inputA) (set! result (vector-set! (vector "") 0 inputA)))
	                (if (number? inputA) (set! result (vector-set! (vector "") 0 inputA)))
	                (if (null? inputA) (set! result (make-vector 0)))
	            )
	       )
	       result
    )
)
;------------------------------------------------------

(define ( MSK-list2Vector inputA ) 
    (let* (
	        (result "")
	        (count 0)
	        (listlength 0)
	        (temp 0)
	       )
            (if (list? inputA) 
                (begin 
                    (set! listlength (MSK-count inputA))
                    (set! result (make-vector listlength))
                    (while (< count listlength)
                        (begin
                            (set! temp (MSK-getValueByIndex inputA count))
                            (set! result (vector-set! result count temp))
                            (set! count (+ count 1))
                        )
                    )
                )
            )
	       result
    )
)

;------------------------------------------------------

(define ( MSK-pushVec vec add ) 
    (let* (
	        (result "")
	       )
	       (set! result ( MSK-vectorAppend vec add))
	       result
    )
)
;------------------------------------------------------

(define ( MSK-unshiftVec vec add ) 
    (let* (
	        (result "")
	       )
	       (set! result ( MSK-vectorAppend add vec ))
	       result
    )
)
;------------------------------------------------------

(define ( MSK-popVec vec ) 
    (let* (
	        (result (make-vector 0))
	        (vecLength 0)
	        (count 0)
	        (temp 0)
	       )
	       (if (vector? vec)
	            (begin 
	                (set! vecLength (vector-length vec))
	                (set! temp (- vecLength 1))
	                (set! result (make-vector temp ))
	                (while (< count temp)
	                    (begin 
	                        (vector-set! result count (vector-ref vec count))
	                        (set! count (+ count 1))
	                    )
	                )
	            )
	       )
	       result
    )
)

(define ( MSK-shiftVec vec ) 
    (let* (
	        (result (make-vector 0))
	        (vecLength 0)
	        (count 1)
	        (temp 0)
	       )
	       (if (vector? vec)
	            (begin 
	                (set! vecLength(vector-length vec))
	                (set! result (make-vector (- vecLength 1)))
	                (while (< count vecLength )
	                    (begin 
	                        (set! temp (- count 1))
	                        (vector-set! result temp (vector-ref vec count))
	                        (set! count (+ count 1))
	                    )
	                )
	            )
	       )
	       result
    )
)
;------------------------------------------------------

(define ( MSK-reversVec vec ) 
    (let* (
	        (result (make-vector 0))
	        (vecLength 0)
	        (count 0)
	        (temp 0)
	       )
	       (if (vector? vec)
	            (begin 
	                (set! vecLength(vector-length vec))
	                (set! result (make-vector vecLength ))
	                (while (< count vecLength)
	                    (begin 
	                        (set! temp (- vecLength count))
	                        (set! temp (- temp 1))
	                        (vector-set! result temp (vector-ref vec count))
	                        (set! count (+ count 1))
	                    )
	                )
	            )
	       )
	       result
    )
)
;------------------------------------------------------

(define ( MSK-joinVec vec delimita) 
    (let* (
	        (result "")
	        (vecLength 0)
	        (count 0)
	        (temp 0)
	       )
	        (if (number? delimita) (set! delimita (number->string delimita)))
	        (if (list? delimita) (set! delimita (MSK-join delimita "")))
	        (if (null? delimita) (set! delimita ""))
	        (if (vector? vec)
	            (begin 
	                (set! vecLength(vector-length vec))
	                (while (< count vecLength)
	                    (begin 
	                        (if (< 0 count) (set! result (string-append result delimita)))
	                        (set! temp (vector-ref vec count))
	                        (if (string? temp) (set! result (string-append result temp)))
	                        (if (number? temp) (set! result (string-append result (number->string temp))))
	                        (if (list? temp) (set! result (string-append result (MSK-join temp ""))))
	                        (set! count (+ count 1))
	                    )
	                )
	            )
	       )
	       result
    )
)
;------------------------------------------------------

(define ( MSK-split2Vec string delimita) 
    (let* (
	        (result (make-vector 0))
	       )
        (if (number? delimita) (set! delimita (number->string delimita)))
        (if (list? delimita) (set! delimita (MSK-join delimita "")))
        (if (null? delimita) (set! delimita ""))
        (if (string? string)
            (begin 
                (set! result (MSK-split string delimita))
                (set! result (MSK-list2Vector result))
            )
        )
        result
    )
)
;--------------------------------------------------
(script-fu-register "Mansiki-vector"
		    "Mansiki-vector(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2008/03/18"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-vector"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
