; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-TitleScriptManger ) 
	(gimp-message  "TitleScriptManger")
)
(define ( MSK-getScriptFileSuffix )
	"_scriptFile.txt"
)
;--------------------------------------------------漫画タイトルファイル作成
(define ( MSK-buildTitleScriptFile
			title
			filePrefix
			pageNum
			pageNumMainStart
			pageNumMainEnd
			paperSize
			targetDPI
			monitorSizeX
			monitorSizeY
			optimazingLevel2MonitorSize
			startSide
			pageFlowDirection
			author
			license
			severaltimesAs
	 ) 
	(let* (
			(writeList (list "=========The File Manga Paper Setting For Mansiki ==============="))
			(scriptFileName (string-append filePrefix ( MSK-getScriptFileSuffix )))
		)
		(set! writeList (MSK-push writeList "[titleSetting]"))
		(set! writeList (MSK-push writeList (string-append "title='" 			title 							"'")))
		(set! writeList (MSK-push writeList (string-append "filePrefix='" 		filePrefix 						"'")))
		(set! writeList (MSK-push writeList (string-append "pageNum='" 			(number->string pageNum) 		"'")))
		(set! writeList (MSK-push writeList (string-append "pageNumMainStart='" (number->string pageNumMainStart) "'")))
		(set! writeList (MSK-push writeList (string-append "pageNumMainEnd='" 	(number->string pageNumMainEnd) "'")))
		(set! writeList (MSK-push writeList (string-append "paperSize='" 		paperSize 						"'")))
		(set! writeList (MSK-push writeList (string-append "targetDPI='" 		(number->string targetDPI) 		"'")))
		(set! writeList (MSK-push writeList (string-append "monitorSizeX='"		(number->string monitorSizeX) 	"'")))
		(set! writeList (MSK-push writeList (string-append "monitorSizeY='" 	(number->string monitorSizeY) 	"'")))
		(set! writeList (MSK-push writeList (string-append "optimazingLevel2MonitorSize='" (number->string optimazingLevel2MonitorSize) "'")))
		(set! writeList (MSK-push writeList (string-append "startSide='" 		startSide 						"'")))
		(set! writeList (MSK-push writeList (string-append "pageFlowDirection='" pageFlowDirection 				"'")))
		(set! writeList (MSK-push writeList (string-append "author='" 			author 							"'")))
		(set! writeList (MSK-push writeList (string-append "license='" 			license 						"'")))
		(set! writeList (MSK-push writeList (string-append "severaltimesAs='" 	(number->string severaltimesAs)	"'")))
		(set! writeList (MSK-push writeList "[end]"))
		(set! writeList (MSK-push writeList "==========following Manga Scripts======="))
		( MSK-WriteOut scriptFileName writeList)
    	scriptFileName
	)
    
)
;--------------------------------------------------タイトルファイルからの読み込み
(define (MSK-getArgesOnScriptFile fileName
	 ) 
	(let* (
			(argesHash ( MSK-getBigSectHashFromFile "titleSetting" fileName) )
			(resuktList (list
					( MSK-getValueFromHash argesHash "title")
					( MSK-getValueFromHash argesHash "filePrefix")
					( MSK-string2number ( MSK-getValueFromHash argesHash "pageNum"))
					( MSK-string2number ( MSK-getValueFromHash argesHash "pageNumMainStart"))
					( MSK-string2number ( MSK-getValueFromHash argesHash "pageNumMainEnd"))
					( MSK-getValueFromHash argesHash "paperSize")
					( MSK-string2number ( MSK-getValueFromHash argesHash "targetDPI"))
					( MSK-string2number ( MSK-getValueFromHash argesHash "monitorSizeX"))
					( MSK-string2number ( MSK-getValueFromHash argesHash "monitorSizeY"))
					( MSK-string2number ( MSK-getValueFromHash argesHash "optimazingLevel2MonitorSize"))
					( MSK-getValueFromHash argesHash "startSide")
					( MSK-getValueFromHash argesHash "pageFlowDirection")
					( MSK-getValueFromHash argesHash "author")
					( MSK-getValueFromHash argesHash "license")
					( MSK-string2number ( MSK-getValueFromHash argesHash "severaltimesAs"))
				)
			)
		)
		resuktList
	) 
)
;--------------------------------------------------タイトルファイルからの所定ページScriptの読み込み＆表示
(define (MSK-showScriptOnThePage imageID) 
	(let* (
			(resultScript 		(list ( MSK-getTitleParasite 		imageID)))
			(fileName (string-append ( MSK-getFilePrefixParasite imageID )( MSK-getScriptFileSuffix )))
			(pageNum 			( MSK-getPageNumParasite 			imageID))
			(selfPageNum 		( MSK-getSelfPageNumParasite 		imageID))
			(pageNumMainStart 	( MSK-getPageNumMainStartParasite 	imageID))
			(pageNumMainEnd 	( MSK-getPageNumMainEndParasite 	imageID))
			(MPtype "")
			(key "==")
			(fileLines (list ""))
			(lineCount 0)
			(count 0)
			(showFlag 0)
			(line 0)
		)
		(if (eqv? 1 ( MSK-existTheFile fileName) )
			(begin
				(set! MPtype ( MSK-getMPtype pageNum pageNumMainStart pageNumMainEnd))
				(set! key (string-append key MPtype ( MSK-getIntStrAt0Head selfPageNum 3) "/" ( MSK-getIntStrAt0Head pageNum 3) "=="))
				
				;(gimp-message (string-append (number->string lineCount) key))
				(set! fileLines ( MSK-ReadIn fileName))
				(set! lineCount ( MSK-count fileLines ) )
      			(while (< count lineCount)  
      				(set! line (MSK-getValueByIndex fileLines count))
				;(gimp-message (string-append (number->string lineCount) line))
      				(if (or (equal? line key ) (eqv? showFlag 1))
      					(begin 
      						(if (equal? line key )
      							(begin
      								(set! showFlag 1)
      								(set! resultScript (MSK-push resultScript line ))
      							)
      							(begin 
      								(if (and (equal? "==" (MSK-Right line 2)) (equal? "==" (MSK-Left line 2)) (<= 16 ( MSK-length line )))
      									(begin 
      										(set! showFlag 0)
      										(set! count (+ lineCount 4))
      									)
      									(begin 
      										(set! resultScript (MSK-push resultScript line ))
      										
      									)
      								)
      								
      							)
      						)
      					)
      				)
      				(set! count(+ count 1))
      			)
				(gimp-message ( MSK-join resultScript " \n "))
			)
			(begin
				(gimp-message "Sorry No data On The MangaPapaer...")
			)
		)
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-TitleScriptManger"
		    "Mansiki-TitleScriptManger"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2008/10/03"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-TitleScriptManger"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
