; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-PapaerUnit ) 
	(gimp-message  "BuildMangaPaper")
	
)
;--------------------------------------------------A4サイズを返します。単位はmmで
(define ( MSK-TempDPIforGuideSetting ) 
	150
)
;--------------------------------------------------A4サイズを返します。単位はmmで
(define ( MSK-getGuideFilePath size) 
    (let* (
		(filePathHash ( MSK-getBigSectHash "MPpaperFlames") )
		(key (string-append size "_150" ))
		(rezultPath ( MSK-getValueFromHash filePathHash key) )
		)
		rezultPath
	)
)
;--------------------------------------------------A4サイズを返します。単位はmmで
(define ( MSK-getOtherGuideFilePath size startEndFlag numberString2) 
    (let* (
		(filePathHash ( MSK-getBigSectHash "MPotherFlames") )
		(key (string-append size startEndFlag numberString2 ))
		(rezultPath ( MSK-getValueFromHash filePathHash key) )
		)
		( MSK-getValueFromHash filePathHash key)
	)
)

;--------------------------------------------------A4サイズを返します。単位はmmで
(define ( MSK-makeNewMangaTitleByTitleScriptFile
		fileName
	)
    (let* (
			(currentImageID -1)
			(pageCount 0)
			(pageType "")
			(argesListOnFile (MSK-getArgesOnScriptFile fileName) )
			(title 							( MSK-getValueByIndex argesListOnFile 0))
			(filePrefix						( MSK-getValueByIndex argesListOnFile 1))
			(pageNum						( MSK-getValueByIndex argesListOnFile 2))
			(pageNumMainStart				( MSK-getValueByIndex argesListOnFile 3))
			(pageNumMainEnd					( MSK-getValueByIndex argesListOnFile 4))
			(paperSize						( MSK-getValueByIndex argesListOnFile 5))
			(targetDPI						( MSK-getValueByIndex argesListOnFile 6))
			(monitorSizeX					( MSK-getValueByIndex argesListOnFile 7))
			(monitorSizeY					( MSK-getValueByIndex argesListOnFile 8))
			(optimazingLevel2MonitorSize	( MSK-getValueByIndex argesListOnFile 9))
			(startSide						( MSK-getValueByIndex argesListOnFile 10))
			(pageFlowDirection				( MSK-getValueByIndex argesListOnFile 11))
			(author							( MSK-getValueByIndex argesListOnFile 12))
			(license						( MSK-getValueByIndex argesListOnFile 13))
			(severaltimesAs					( MSK-getValueByIndex argesListOnFile 14))
		)

        (while (> pageNum pageCount)
        	(set! pageCount(+ pageCount 1))
			(set! pageType ( MSK-getMPtype pageCount pageNumMainStart pageNumMainEnd))
        	(gimp-message  (string-append "BuildMangaPaper Now Building " (number->string pageCount) " page!"))
        	(if (equal? "Main_" pageType)
        		(begin 
        			;(gimp-message  (string-append "BuildMangaPaper START MAIN!" pageType))
					( MSK-buildMangaPageMain 
						title
						filePrefix 
						pageNum
						pageNumMainStart
						pageNumMainEnd
						paperSize
						targetDPI
						monitorSizeX
						monitorSizeY
						optimazingLevel2MonitorSize
						startSide
						pageFlowDirection
						pageCount
						author
						license
						pageType
						severaltimesAs
					)
				)
				(begin 
        			;(gimp-message  (string-append "BuildMangaPaper START OTHER!" pageType))
					( MSK-buildMangaPageOther
						title
						filePrefix
						pageNum
						pageNumMainStart
						pageNumMainEnd
						paperSize
						targetDPI
						monitorSizeX
						monitorSizeY
						optimazingLevel2MonitorSize
						startSide
						pageFlowDirection
						pageCount
						author
						license
						pageType
						severaltimesAs
					) 
				)
        	)
        )
        (gimp-message  "BuildMangaPaper END!")
	)
)
;--------------------------------------------------A4サイズを返します。単位はmmで
(define ( MSK-makeNewMangaTitleScript
		dir4Title
		title
		filePrefix
		pageNum
		pageNumMainStart
		pageNumMainEnd
		paperSizeNum
		targetDPI
		monitorSizeX
		monitorSizeY
		optimazingLevel2MonitorSize
		startSideNum
		pageFlowDirectionNum
		author
		license
		severaltimesAsNum
	) 
    (let* (
			(currentImageID -1)
			(pageCount 0)
			(paperSize "A4")
			(startSide "right")
			(pageFlowDirection "right2left")
			(pageType "")
			(severaltimesAs 1)
		)
		(set! filePrefix (string-append dir4Title "/"　filePrefix ( MSK-getNowTimeYYMMDDhhmmss) ))
		(if (eqv? paperSizeNum 0) 
			(set! paperSize "B5")
		)
		(if (eqv? paperSizeNum 2) 
			(set! paperSize "B4")
		)
		(if (eqv? startSideNum 0) 
			(set! startSide "left")
		)
		(if (eqv? pageFlowDirectionNum 0) 
			(set! pageFlowDirection "left2right")
		)
		(if (eqv? severaltimesAsNum 1) 
			(set! severaltimesAs 0.5)
		)
		(if (eqv? severaltimesAsNum 2) 
			(set! severaltimesAs 2)
		)
		(if (eqv? severaltimesAsNum 3) 
			(set! severaltimesAs 4)
		)
		(if (eqv? severaltimesAsNum 4) 
			(set! severaltimesAs 8)
		)
        (MSK-buildTitleScriptFile
				title
				filePrefix
				pageNum
				pageNumMainStart
				pageNumMainEnd
				paperSize
				targetDPI
				monitorSizeX
				monitorSizeY
				optimazingLevel2MonitorSize
				startSide
				pageFlowDirection
				author
				license
				severaltimesAs
        )
	)
)
;--------------------------------------------------A4サイズを返します。単位はmmで
(define ( MSK-makeNewMangaTitle
		dir4Title
		title
		filePrefix
		pageNum
		pageNumMainStart
		pageNumMainEnd
		paperSizeNum
		targetDPI
		monitorSizeX
		monitorSizeY
		optimazingLevel2MonitorSize
		startSideNum
		pageFlowDirectionNum
		author
		license
		severaltimesAsNum
	) 
    (let* (
			(currentImageID -1)
			(pageCount 0)
			(paperSize "A4")
			(startSide "right")
			(pageFlowDirection "right2left")
			(pageType "")
			(severaltimesAs 1)
		)
		(set! filePrefix (string-append dir4Title "/"　filePrefix ( MSK-getNowTimeYYMMDDhhmmss) ))
		(if (eqv? paperSizeNum 0) 
			(set! paperSize "B5")
		)
		(if (eqv? paperSizeNum 2) 
			(set! paperSize "B4")
		)
		(if (eqv? startSideNum 0) 
			(set! startSide "left")
		)
		(if (eqv? pageFlowDirectionNum 0) 
			(set! pageFlowDirection "left2right")
		)
		(if (eqv? severaltimesAsNum 1) 
			(set! severaltimesAs 0.5)
		)
		(if (eqv? severaltimesAsNum 2) 
			(set! severaltimesAs 2)
		)
		(if (eqv? severaltimesAsNum 3) 
			(set! severaltimesAs 4)
		)
		(if (eqv? severaltimesAsNum 4) 
			(set! severaltimesAs 8)
		)
        (while (> pageNum pageCount)
        	(set! pageCount(+ pageCount 1))
			(set! pageType ( MSK-getMPtype pageCount pageNumMainStart pageNumMainEnd))
        	(gimp-message  (string-append "BuildMangaPaper Now Building " (number->string pageCount) " page!"))
        	(if (equal? "Main_" pageType)
        		(begin 
        			;(gimp-message  (string-append "BuildMangaPaper START MAIN!" pageType))
					( MSK-buildMangaPageMain 
						title
						filePrefix 
						pageNum
						pageNumMainStart
						pageNumMainEnd
						paperSize
						targetDPI
						monitorSizeX
						monitorSizeY
						optimazingLevel2MonitorSize
						startSide
						pageFlowDirection
						pageCount
						author
						license
						pageType
						severaltimesAs
					)
				)
				(begin 
        			;(gimp-message  (string-append "BuildMangaPaper START OTHER!" pageType))
					( MSK-buildMangaPageOther
						title
						filePrefix
						pageNum
						pageNumMainStart
						pageNumMainEnd
						paperSize
						targetDPI
						monitorSizeX
						monitorSizeY
						optimazingLevel2MonitorSize
						startSide
						pageFlowDirection
						pageCount
						author
						license
						pageType
						severaltimesAs
					) 
				)
        	)
        )
        (gimp-message  "BuildMangaPaper END!")
	)
)
;--------------------------------------------------
(define ( MSK-getNowTimeYYMMDDhhmmss) 
	(let* (
		(dateList (MSK-secToDateList (realtime)))
		(retYear    ( MSK-getValueByIndex dateList 0))
		(retMonth   ( MSK-getValueByIndex dateList 1))
		(retDay     ( MSK-getValueByIndex dateList 2))
		(retHour    ( MSK-getValueByIndex dateList 3))
		(retMin     ( MSK-getValueByIndex dateList 4))
		(retSec     ( MSK-getValueByIndex dateList 5))
		)
		(string-append
			( MSK-Right retYear 2)
			retMonth
			retDay
			retHour
			retMin
			retSec
		)
	)
)
;--------------------------------------------------原稿イメージ情報パラサイト作成
(define ( MSK-setParasite2MangaPaper 
		imageID
		title
		filePrefix
		pageNum
		pageNumMainStart
		pageNumMainEnd
		paperSize
		targetDPI
		monitorSizeX
		monitorSizeY
		optimazingLevel2MonitorSize
		startSide
		pageFlowDirection
		selfPageNum
		author
		license
		insertDateTime
		updateDateTime
		version
		severaltimesAs
		) 
	( MSK-setTitleParasite 							imageID title)
	( MSK-setFilePrefixParasite 					imageID filePrefix)
	( MSK-setPageNumParasite 						imageID pageNum)
	( MSK-setPageNumMainStartParasite 				imageID pageNumMainStart)
	( MSK-setPageNumMainEndParasite 				imageID pageNumMainEnd)
	( MSK-setPaperSizeParasite		 				imageID paperSize)
	( MSK-setTargetDPIParasite		 				imageID targetDPI)
	( MSK-setMonitorSizeXParasite	 				imageID monitorSizeX)
	( MSK-setMonitorSizeYParasite	 				imageID monitorSizeY)
	( MSK-setOptimazingLevel2MonitorSizeParasite	imageID optimazingLevel2MonitorSize)
	( MSK-setStartSideParasite 						imageID startSide)
	( MSK-setPageFlowDirectionParasite 				imageID pageFlowDirection)
	( MSK-setSelfPageNumParasite				 	imageID selfPageNum)
	( MSK-setAuthorParasite				 			imageID author)
	( MSK-setLicenseParasite						imageID license)
	( MSK-getInsertDateTimeParasite				 	imageID insertDateTime)
	( MSK-setUpdateDateTimeParasite				 	imageID updateDateTime)
	( MSK-setVersionParasite				 		imageID version)
	( MSK-setSeveraltimesAsParasite				 	imageID severaltimesAs)
)
;--------------------------------------------------setter Title2Image
(define ( MSK-setTitleParasite imageID title)
	( MSK-setParasiteToImage imageID  "MSK-MP_title" title)
)
;--------------------------------------------------getter Title
(define ( MSK-getTitleParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_title" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setFilePrefixParasite imageID filePrefix)
	( MSK-setParasiteToImage imageID  "MSK-MP_filePrefix" filePrefix)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getFilePrefixParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_filePrefix" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setPageNumParasite imageID pageNum)
	( MSK-setParasiteToImage imageID  "MSK-MP_pageNum" (number->string pageNum))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getPageNumParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_pageNum"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setPageNumMainStartParasite imageID pageNumMainStart)
	( MSK-setParasiteToImage imageID  "MSK-MP_pageNumMainStart" (number->string pageNumMainStart))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getPageNumMainStartParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_pageNumMainStart"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setPageNumMainEndParasite imageID pageNumMainEnd)
	( MSK-setParasiteToImage imageID  "MSK-MP_pageNumMainEnd" (number->string pageNumMainEnd))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getPageNumMainEndParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_pageNumMainEnd"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setPaperSizeParasite imageID paperSize)
	( MSK-setParasiteToImage imageID  "MSK-MP_paperSize" paperSize)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getPaperSizeParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_paperSize" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setTargetDPIParasite imageID targetDPI)
	( MSK-setParasiteToImage imageID  "MSK-MP_targetDPI" (number->string targetDPI))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getTargetDPIParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_targetDPI"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setMonitorSizeXParasite imageID monitorSizeX)
	( MSK-setParasiteToImage imageID  "MSK-MP_monitorSizeX" (number->string monitorSizeX))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getMonitorSizeXParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_monitorSizeX"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setMonitorSizeYParasite imageID monitorSizeY)
	( MSK-setParasiteToImage imageID  "MSK-MP_monitorSizeY" (number->string monitorSizeY))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getMonitorSizeYParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_monitorSizeY"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setOptimazingLevel2MonitorSizeParasite imageID optimazingLevel2MonitorSize)
	( MSK-setParasiteToImage imageID  "MSK-MP_optimazingLevel2MonitorSize" (number->string optimazingLevel2MonitorSize))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getOptimazingLevel2MonitorSizeParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_optimazingLevel2MonitorSize"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setOptimazingLevel2MonitorSizeParasite imageID optimazingLevel2MonitorSize)
	( MSK-setParasiteToImage imageID  "MSK-MP_optimazingLevel2MonitorSize" (number->string optimazingLevel2MonitorSize))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getOptimazingLevel2MonitorSizeParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_optimazingLevel2MonitorSize"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成( MSK-getPaperUnit paperSize) 	
(define ( MSK-setStartSideParasite imageID startSide)
	( MSK-setParasiteToImage imageID  "MSK-MP_startSide" startSide)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getStartSideParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_startSide" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setPageFlowDirectionParasite imageID pageFlowDirection)
	( MSK-setParasiteToImage imageID  "MSK-MP_pageFlowDirection" pageFlowDirection)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getPageFlowDirectionParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_pageFlowDirection" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setSelfPageNumParasite imageID selfPageNum)
	( MSK-setParasiteToImage imageID  "MSK-MP_selfPageNum" (number->string selfPageNum))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getSelfPageNumParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_selfPageNum"  ))
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setAuthorParasite imageID author)
	( MSK-setParasiteToImage imageID  "MSK-MP_author" author)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getAuthorParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_author" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setLicenseParasite imageID license)
	( MSK-setParasiteToImage imageID  "MSK-MP_license" license)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getLicenseParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_license" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setInsertDateTimeParasite imageID insertDateTime)
	( MSK-setParasiteToImage imageID  "MSK-MP_insertDateTime" insertDateTime)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getInsertDateTimeParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_insertDateTime" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setUpdateDateTimeParasite imageID updateDateTime)
	( MSK-setParasiteToImage imageID  "MSK-MP_updateDateTime" updateDateTime)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getUpdateDateTimeParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_updateDateTime" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setVersionParasite imageID version)
	( MSK-setParasiteToImage imageID  "MSK-MP_version" version)
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getVersionParasite imageID )
	( MSK-getParasiteStringFromImage imageID  "MSK-MP_version" )
)
;--------------------------------------------------setterテキストレイヤー情報パラサイト作成
(define ( MSK-setSeveraltimesAsParasite imageID severaltimesAs)
	( MSK-setParasiteToImage imageID  "MSK-MP_SeveraltimesAs" (number->string severaltimesAs))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getSeveraltimesAsParasite imageID )
	(MSK-string2number ( MSK-getParasiteStringFromImage imageID  "MSK-MP_SeveraltimesAs" ))
)
;--------------------------------------------------getterテキストレイヤー情報パラサイト作成
(define ( MSK-getSelfSideParasite imageID )
    (let* (
			(selfPageNum 		( MSK-getSelfPageNumParasite imageID ))
			(startSide		 	( MSK-getStartSideParasite imageID ))
			(sideFlag ( MSK-mod selfPageNum 2))
		)
		(if (eqv? sideFlag 1)
			(begin
				(if(equal? startSide "right")
					"left"
					"right"
				) 
			)
			(begin
				(if(equal? startSide "right")
					"right"
					"left"
				) 
			)
		)
	)
)
;--------------------------------------------------Main形式のページを作成
(define ( MSK-buildMangaPageMain 
		title
		filePrefix
		pageNum
		pageNumMainStart
		pageNumMainEnd
		paperSize
		targetDPI
		monitorSizeX
		monitorSizeY
		optimazingLevel2MonitorSize
		startSide
		pageFlowDirection
		selfPageNum
		author
		license
		pageType
		severaltimesAs
	) 
    (let* (
			(newImageID ( MSK-newImage 1 1))
			(newLayerID ( MSK-newLayer newImageID ))
			(baseLayerName 		( MSK-setLayerName newLayerID "背景"))
			(komaLayerName 		( MSK-setLayerName ( MSK-newLayer newImageID ) "コマ"))
			(balloonLayerName 	( MSK-setLayerName ( MSK-newLayer newImageID ) "吹き出し"))
			(lineLayerName 		( MSK-setLayerName ( MSK-newLayer newImageID ) "本番"))
			(draftLayerName 	( MSK-setLayerName ( MSK-newLayer newImageID ) "下書き"))
			(hilightLayerName 	( MSK-setLayerName ( MSK-newLayer newImageID ) "ハイライト"))
			(nowDateTime 		( MSK-getNowDateTime ) )
			(state 				"S" )
			(version 			"01" )
			(insertDateTime 	nowDateTime )
			(updateDateTime 	nowDateTime )
			(xANDy '())
			(offsetX2 0)
			(offsetY2 0)
			(fileName ( MSK-makeMangaPageFileName filePrefix selfPageNum pageNum pageNumMainStart pageNumMainEnd pageType version state))
			(optimizedSizeList ())
		)
		( MSK-setParasite2MangaPaper 
			newImageID
			title
			filePrefix
			pageNum
			pageNumMainStart
			pageNumMainEnd
			paperSize
			targetDPI
			monitorSizeX
			monitorSizeY
			optimazingLevel2MonitorSize
			startSide
			pageFlowDirection
			selfPageNum
			author
			license
			insertDateTime
			updateDateTime
			version
			severaltimesAs
		)
		;(gimp-message "buildMangaPageMain cc1")
;------------------
		(set! xANDy ( MSK-culcOptimaizedSize paperSize 0 monitorSizeX monitorSizeY ( MSK-TempDPIforGuideSetting ) severaltimesAs))
		( MSK-resizeImage newImageID (MSK-getValueByIndex xANDy 0) (MSK-getValueByIndex xANDy 1) 0 0 )
		;(gimp-message "buildMangaPageMain cc30aa")
		(set! newLayerID
			( MSK-buildMPGuideLayer
				newImageID
				title
				filePrefix
				pageNum
				pageNumMainStart
				pageNumMainEnd
				paperSize
				targetDPI
				monitorSizeX
				monitorSizeY
				optimazingLevel2MonitorSize
				startSide
				pageFlowDirection
				selfPageNum
				author
				license
				insertDateTime
				updateDateTime
				version
			)
		)
		;(gimp-message "buildMangaPageMain cc30a")
		
		( MSK-setLayerName newLayerID "ガイド")
		( MSK-setLockLayer  newLayerID)
		( MSK-fillLayerColor  (MSK-getLayerIDByName newImageID baseLayerName) '(255 255 255)) 
		(set! newLayerID( MSK-loadAsLayer ( MSK-getGuideFilePath paperSize)  newImageID) )
		( MSK-setLayerName newLayerID "ガイド2")
		( MSK-setLockLayer  newLayerID)
		( MSK-sortLayerZindexByNameList newImageID 
			(list
				 hilightLayerName lineLayerName balloonLayerName komaLayerName draftLayerName "ガイド" "ガイド2" baseLayerName 
			)
		) 
		( MSK-setActiveLayer ( MSK-getLayerIDByName newImageID draftLayerName)  )
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID draftLayerName)) 
		( MSK-setOpacityLayer (MSK-getLayerIDByName newImageID draftLayerName) 30)
		;(gimp-message "buildMangaPageMain cc30a")
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID komaLayerName)) 
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID balloonLayerName)) 
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID lineLayerName)) 
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID hilightLayerName)) 
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID baseLayerName)) 
		( MSK-setModeLayer ( MSK-getLayerIDByName newImageID baseLayerName) NORMAL-MODE)
		( MSK-setModeLayer ( MSK-getLayerIDByName newImageID hilightLayerName) NORMAL-MODE)
;------------------
		;(gimp-message "buildMangaPageMain cc30b")
		(if (eqv? optimazingLevel2MonitorSize 2)
			(begin 

				(set! xANDy ( MSK-culcOptimaizedSize paperSize 1 monitorSizeX monitorSizeY targetDPI severaltimesAs))
			    ( MSK-scaleXcfImage newImageID (MSK-getValueByIndex xANDy 0) (MSK-getValueByIndex xANDy 1))
				(set! offsetX2  (MSK-getValueByIndex xANDy 0))
				(set! offsetY2  (MSK-getValueByIndex xANDy 1))
				;(gimp-message (string-append "culcOptimaizedSize  " (number->string offsetX2) "/" (number->string offsetY2)))
				(set! xANDy ( MSK-culcOptimaizedSize paperSize optimazingLevel2MonitorSize monitorSizeX monitorSizeY targetDPI severaltimesAs))
				(set! offsetX2 (/ (- (MSK-getValueByIndex xANDy 0) offsetX2) 2))
				(set! offsetY2 (/ (- (MSK-getValueByIndex xANDy 1) offsetY2) 2))
				;(gimp-message (string-append "culcOptimaizedSize  " (number->string (MSK-getValueByIndex xANDy 0)) "/" (number->string (MSK-getValueByIndex xANDy 1))))
				( MSK-resizeImage newImageID (MSK-getValueByIndex xANDy 0) (MSK-getValueByIndex xANDy 1) offsetX2 offsetY2)
			)
			(begin 
				;(gimp-message "buildMangaPageMain cc4b")
				(set! xANDy ( MSK-culcOptimaizedSize paperSize optimazingLevel2MonitorSize monitorSizeX monitorSizeY targetDPI severaltimesAs))
				( MSK-scaleXcfImage newImageID (MSK-getValueByIndex xANDy 0) (MSK-getValueByIndex xANDy 1))
			)
		)
		( MSK-saveXcfImage newImageID fileName) 
	)
)
;--------------------------------------------------
(define ( MSK-makeMangaPageFileName filePrefix selfPageNum pageNum pageNumMainStart pageNumMainEnd pageType version state)
    (let* (
			(pageNumMain "0-1")
		)
		;ファイルプレフィックス＋バージョン＋状態＋ページタイプ＋ページ数＋トータル＋拡張子
		(if (not (equal? "Main_" pageType))
			(set! pageNumMain  (MSK-getNowPageNumberAtOtherFrame selfPageNum pageNumMainStart pageNumMainEnd))
			(set! pageNumMain ( MSK-getIntStrAt0Head (+(- selfPageNum pageNumMainStart ) 1) 3))
		)
		(string-append ;( MSK-scaleXcfImage imageID width height)
			filePrefix 
			"_v"
			version
			state
			"_"
			pageType
			pageNumMain
			"_"
			( MSK-getIntStrAt0Head selfPageNum 3)
			"_"
			( MSK-getIntStrAt0Head pageNum 3)
			".xcf"
		)
	)
)

;--------------------------------------------------
(define ( MSK-getMPtype pageNum pageNumMainStart pageNumMainEnd)
	(let* (
			(pageType "Main_")
		)

		(if(< pageNum pageNumMainStart)	
			(set! pageType "Front")
		)
		(if(> pageNum pageNumMainEnd)
			(set! pageType "Rear_")
		)
		pageType
	)
)

;--------------------------------------------------
(define ( MSK-culcOptimaizedSize paperSize optimazingLevel2MonitorSize monitorSizeX monitorSizeY targetDPI severaltimesAs)
	;目的の下書き画像サイズ縦px＝（monitorSizeY - Bfx*2 - By*2）* ( Py / ( Oy + Tpx*2 ) )
	;目的の下書き画像サイズ横px＝目的の下書き画像サイズ縦px * ( Px / Py )
	(let* (
			(fullX 0)
			(fullY 0)
			(papaUnit ( MSK-getPaperUnit paperSize));A4デフォ;紙のサイズ：横、縦、内枠のサイズ：横、縦　外枠のサイズ：横、縦　断ち切り幅
			(tempX 0)
			(tempY 0)
			(Px (MSK-string2number (MSK-getValueByIndex papaUnit 0)))
			(Py (MSK-string2number (MSK-getValueByIndex papaUnit 1)))
			(Ix (* (MSK-string2number (MSK-getValueByIndex papaUnit 2)) 1.017))
			(Iy (* (MSK-string2number (MSK-getValueByIndex papaUnit 3)) 1.017))
			(Ox (MSK-string2number (MSK-getValueByIndex papaUnit 4)))
			(Oy (MSK-string2number (MSK-getValueByIndex papaUnit 5)))
			(Bx 0)
			(By 18)
			(Bfx 5)
			(Bfy 5)
			(Tx (MSK-getValueByIndex papaUnit 6))
			(tempList "")
		)

		(if (or (eqv? optimazingLevel2MonitorSize 1)(eqv? optimazingLevel2MonitorSize 2));用紙内枠サイズまで
			(begin 
				(if (> monitorSizeX monitorSizeY)
					(begin 
						(set! fullY (* (/ (- monitorSizeY (+ (* 2 By) (* 2 Bfy))) Iy) Py))
						(set! fullX (* fullY (/ Px Py)))
					)
					(begin 
						(set! fullX (* (/(- monitorSizeX (+ (* 2 Bx) (* 2 Bfx))) Ix) Px))
						(set! fullY (* fullX (/ Py Px)))
					)
				)
				(if (eqv? optimazingLevel2MonitorSize 2);用紙内枠サイズも切り詰める
					(begin 
				;(gimp-message "culcOptimaizedSize aa3")
						(if (> monitorSizeX monitorSizeY)
							(begin 
								(set! fullY (* (/(- monitorSizeY (+ (* 2 By) (* 2 Bfy))) Iy) Py))
								(set! fullX (* fullY (/ Px Py)))
								(set! fullY (- monitorSizeY (+ (* 2 By) (* 2 Bfy))))
							)
							(begin 
								(set! fullX (* (/(- monitorSizeX (+ (* 2 Bx) (* 2 Bfx))) Ix) Px))
								(set! fullY (* fullX (/ Py Px)))
								(set! fullX (- monitorSizeX (+ (* 2 Bx) (* 2 Bfx))))
							)
						)
					)
				)
				(set! fullX (* fullX severaltimesAs ))
				(set! fullY (* fullY severaltimesAs ))
			)
			(begin 
				(set! tempList ( MSK-getPixcelSizeMangaPaperUnitByDPI paperSize targetDPI))
				(set! fullX (MSK-getValueByIndex tempList 0))
				(set! fullY (MSK-getValueByIndex tempList 1))
			)
		)
				;(gimp-message (string-append "culcOptimaizedSize  " (number->string fullX) "/" (number->string fullY)))
		(list (MSK-string2number fullX) (MSK-string2number fullY))
	)
)
;--------------------------------------------------
(define ( MSK-buildMangaPageOther
		title
		filePrefix
		pageNum
		pageNumMainStart
		pageNumMainEnd
		paperSize
		targetDPI
		monitorSizeX
		monitorSizeY
		optimazingLevel2MonitorSize
		startSide
		pageFlowDirection
		selfPageNum
		author
		license
		pageType
		severaltimesAs
	) 
    (let* (
			(newImageID ( MSK-newImage 1 1))
			(newLayerID ( MSK-newLayer newImageID ))
			(baseLayerName 		( MSK-setLayerName newLayerID "背景"))
			(lineLayerName 		( MSK-setLayerName ( MSK-newLayer newImageID ) "本番"))
			(draftLayerName 	( MSK-setLayerName ( MSK-newLayer newImageID ) "下書き"))
			(hilightLayerName 	( MSK-setLayerName ( MSK-newLayer newImageID ) "ハイライト"))
			(nowDateTime 		( MSK-getNowDateTime ) )
			(state 				"S" )
			(version 			"01" )
			(insertDateTime 	nowDateTime )
			(updateDateTime 	nowDateTime )
			(xANDy '())
			(fileName ( MSK-makeMangaPageFileName filePrefix selfPageNum pageNum pageNumMainStart pageNumMainEnd pageType version state))
			(optimizedSizeList ())
			(number2 0)
			(guidPath ( MSK-getOtherGuideFilePath 
				paperSize 
				pageType
				(MSK-getNowPageNumberAtOtherFrame selfPageNum pageNumMainStart pageNumMainEnd)
				))
		)
		( MSK-setParasite2MangaPaper 
			newImageID
			title
			filePrefix
			pageNum
			pageNumMainStart
			pageNumMainEnd
			paperSize
			targetDPI
			monitorSizeX
			monitorSizeY
			optimazingLevel2MonitorSize
			startSide
			pageFlowDirection
			selfPageNum
			author
			license
			insertDateTime
			updateDateTime
			version
			severaltimesAs
		)
		;(set! newLayerID ( MSK-loadAsLayer templateFileName newImageID) )
		(if (not (equal? guidPath ""))
			(set! newLayerID( MSK-loadAsLayer guidPath newImageID) )
			(set! newLayerID ( MSK-newLayer newImageID ))
		)
		( MSK-setLayerName newLayerID "ガイド")
		( MSK-setLockLayer  newLayerID)
		( MSK-sortLayerZindexByNameList newImageID 
			(list
				"背景" "ガイド" "下書き" "本番" "ハイライト"
			)
		) 
		( MSK-setModeLayer ( MSK-getLayerIDByName newImageID "ハイライト") NORMAL-MODE)
		( MSK-setActiveLayer ( MSK-getLayerIDByName newImageID draftLayerName)  )
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID draftLayerName)) 
		( MSK-setOpacityLayer (MSK-getLayerIDByName newImageID draftLayerName) 30)
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID hilightLayerName)) 
		( MSK-setVisibleLayer  (MSK-getLayerIDByName newImageID baseLayerName)) 
		(set! xANDy( MSK-culcOptimaizedSize paperSize 0 monitorSizeX monitorSizeY targetDPI severaltimesAs))
		( MSK-scaleXcfImage newImageID (MSK-getValueByIndex xANDy 0) (MSK-getValueByIndex xANDy 1))
        			;(gimp-message  (string-append "BuildMangaPaper START OTHER SAVE!" fileName))
		( MSK-saveXcfImage newImageID fileName) 
	)
	　　　　
)
;-------------------------------------------pageCount-------
(define ( MSK-getNowPageNumberAtOtherFrame
		selfPageNum
		pageNumMainStart
		pageNumMainEnd
	) 
	(let* (
			(resultNum -1)
		)
		(if (> pageNumMainStart selfPageNum )
			(set! resultNum selfPageNum)
		
		)
		(if (> selfPageNum pageNumMainEnd )
			(set! resultNum (- selfPageNum pageNumMainEnd))
		)
		( MSK-getIntStrAt0Head resultNum 3)
	)
)

;--------------------------------------------------
(define ( MSK-addNewPageTheMangaTitle
		filePrefix
	)
	　　　　
)
;--------------------------------------------------
(define ( MSK-insertNewPageTheMangaTitle
		filePrefix
	)
	
)
;--------------------------------------------------
(define ( MSK-deletePageTheMangaTitle
		filePrefix
	)
	
)
;--------------------------------------------------
(define ( MSK-MakeScriptFileAndMakeMangaPaper
		dir4Title
		title
		filePrefix
		pageNum
		pageNumMainStart
		pageNumMainEnd
		paperSize
		targetDPI
		monitorSizeX
		monitorSizeY
		optimazingLevel2MonitorSize
		severaltimesAs
		startSide
		pageFlowDirection
		author
		license
	)
	(let* (
			(fileName ( MSK-makeNewMangaTitleScript
					dir4Title
					title
					filePrefix
					pageNum
					pageNumMainStart
					pageNumMainEnd
					paperSize
					targetDPI
					monitorSizeX
					monitorSizeY
					optimazingLevel2MonitorSize
					startSide
					pageFlowDirection
					author
					license
					severaltimesAs
				)
			)
		)
		(MSK-makeNewMangaTitleByTitleScriptFile fileName)
	)
)


;--------------------------------------------------
(script-fu-register "Mansiki-BuildMangaPaper"
		    "Mansiki-BuildMangaPaper(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2008/07/29"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-BuildMangaPaper"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
