; GIMP Script-Fu Mansiki Libs
;Tiny-fu版に変更
(define ( Mansiki-ComvertImage ) 
	(gimp-message  "ComvertImage")
	
)

;--------------------------------------------------取り合えず、ファイル名をGetする。
(define ( MSK-getMansikiNameByType typeprefix ImageID ) 
	(let* (
			(isManski ( MSK-getIsMansikiMPfile ImageID))
		)	
		(if (eqv? 1 isManski)
			( MSK-getMansikiNameListByType typeprefix ImageID ) 
		)
	)
)
;--------------------------------------------------取り合えず、ファイル名をGetする。
(define ( MSK-getMansikiNamePartsList  ImageID ) 
	(let* (
			(isManski ( MSK-getIsMansikiMPfile ImageID))
		)	
		(if (eqv? 1 isManski)
			( MSK-getMansikiNamePartsListByMansikiMPI ImageID ) 
		)
	)
)
;--------------------------------------------------漫式ファイルであるという前提で
(define ( MSK-getMansikiNamePartsListByMansikiMPI  ImageID ) 
	(let* (
			(title ( MSK-getTitleParasite imageID ))
			(filePrefix ( MSK-getFilePrefixParasite imageID ))
			(pageNum ( MSK-getSelfPageNumParasite imageID ))
			(selfPageNum ( MSK-getSelfPageNumParasite imageID ))
			(pageNumMainStart ( MSK-getPageNumMainStartParasite imageID ))
			(pageNumMainEnd ( MSK-getPageNumMainEndParasite imageID ))
			(pageType ( MSK-getMPtype pageCount pageNumMainStart pageNumMainEnd))
			(version ( MSK-getVersionParasite imageID ))
			(paperSize ( MSK-getPaperSizeParasite imageID ))
			(tergetDPI ( MSK-getTargetDPIParasite imageID ))
			(optimizedLevel ( MSK-getOptimazingLevel2MonitorSizeParasite imageID))
			(startSide ( MSK-getStartSideParasite imageID ))
			(pageFlowDirection ( MSK-getPageFlowDirectionParasite imageID ))
			(state "X")
			(count 0)
			(resultList '())
			(fileName "")
			
		)
		(while (> pageNum  count)
			(set! count (+ count 1))
			(set! fileName ( MSK-makeMangaPageFileName filePrefix count pageNum pageNumMainStart pageNumMainEnd pageType version "S"))
			(if ( MSK-existTheFile fileName) 
				(set! resultList (MSK-push resultList (join (list filePrefix count pageNum pageNumMainStart pageNumMainEnd pageType version 
						paperSize (number->string tergetDPI) (number->string optimizedLevel) startSide pageFlowDirection) ",")))
			)
		)
		resultList
	)
)
;--------------------------------------------------取り合えず、ファイル名をGetする。
(define ( MSK-convertImagesAtTilte ImageID) 
	(let* (
			(filePrefix "")
			(selfPageNum "")
			(pageNum "")
			(pageNumMainStart "")
		 	(pageNumMainEnd "")
		 	(pageType "")
		 	(version "")
		 	(state "")
		 	(pageList ( MSK-getMansikiNamePartsList  ImageID ))
		 	(pageCount (MSK-count pageList))
		 	(count 0)
		 	(valueList "")
		 	(paperSize "")
		 	(tergetDPI "")
		 	(optimizedLevel "")
		 	(startSide "")
		 	(pageFlowDirection "")
		 	(fileName "")
		 	(targetDPIsizeFileName "")
		 	(nowImageID 0)
		)
		(while (> pageCount count)
			(set! valueList ( MSK-split (MSK-getValueByIndex pageList count) ","))
			(filePrefix 		(MSK-getValueByIndex valueList 0))
			(selfPageNum 		(MSK-getValueByIndex valueList 1))
			(pageNum 			(MSK-getValueByIndex valueList 2))
			(pageNumMainStart 	(MSK-getValueByIndex valueList 3))
		 	(pageNumMainEnd 	(MSK-getValueByIndex valueList 4))
		 	(pageType 			(MSK-getValueByIndex valueList 5))
		 	(version 			(MSK-getValueByIndex valueList 6))
		 	(paperSize 			(MSK-getValueByIndex valueList 7))
		 	(tergetDPI 			(MSK-getValueByIndex valueList 8))
		 	(optimizedLevel 	(MSK-getValueByIndex valueList 9))
		 	(startSide 			(MSK-getValueByIndex valueList 10))
		 	(pageFlowDirection 	(MSK-getValueByIndex valueList 11))
		 	(set! fileName ( MSK-makeMangaPageFileName filePrefix count pageNum pageNumMainStart pageNumMainEnd pageType version "S"))
		 	(if (equal? "Main_" pageType)
		 		(begin 
		 			(set! nowImageID ( MSK-processingMain fileName count paperSize tergetDPI optimizedLevel startSide pageFlowDirection) )
		 		)
		 		(begin
		 		
		 			(set! nowImageID ( MSK-processingNonMain fileName count paperSize tergetDPI optimizedLevel startSide pageFlowDirection))
		 		)
		 	)
		 	(set! fileName ( MSK-makeMangaPageFileNameWithExtention filePrefix count pageNum pageNumMainStart pageNumMainEnd pageType version "R" "png"))
		 	( MSK-saveXcfImage nowImageID fileName) 
			(set! count (+ count 1))
		)
	)
)
;--------------------------------------------------表紙の処理。
(define ( MSK-processingNonMain fileName selfPageNum paperSize tergetDPI optimizedLevel startSide pageFlowDirection) 
	(let* (( MSK-saveXcfImage imageID fileName) 
			(imageID ( MSK-loadImage fileName ))
			(layerNameList (list "背景" "ガイド" "本番" "ハイライト"))
			(selfSide ( MSK-getSelfSide selfPageNum startSide )
		)	
		( MSK-deleteLayerNoNameOnTheList imageID layerNameList ) 
		( MSK-mergeLayerByName imageID layerNamesList) 
		imageID
	)
)
;--------------------------------------------------本体の処理。
(define ( MSK-processingMain fileName selfPageNum paperSize tergetDPI optimizedLevel startSide pageFlowDirection) 
	(let* (
			(imageID ( MSK-loadImage fileName ))
			(layerNameList (list "背景" "コマ" "吹き出し" "本番" "ハイライト"))
			(selfSide ( MSK-getSelfSide selfPageNum startSide )
			(sizeXandY "")
			(optimizedSizeX 0)
			(optimizedSizeY 0)
		)	
		( MSK-deleteLayerNoNameOnTheList imageID layerNameList ) 
		( MSK-mergeLayerByName imageID layerNamesList) 
		(set! sizeXandY ( MSK-getTrueSizeAtOptimized imageID paperSize tergetDPI optimizedLeve))
		(set! optimizedSizeX (MSK-getValueByIndex sizeXandY 0))
		(set! optimizedSizeY (MSK-getValueByIndex sizeXandY 1))
		imageID
	);--------------------------------------------------
(define ( MSK-makeMangaPageFileName filePrefix selfPageNum pageNum pageNumMainStart pageNumMainEnd pageType version state)
    (let* (
			(pageNumMain "0-1")
		)
		;ファイルプレフィックス＋バージョン＋状態＋ページタイプ＋ページ数＋トータル＋拡張子
		(if (not (equal? "Main_" pageType))
			(set! pageNumMain  (MSK-getNowPageNumberAtOtherFrame selfPageNum pageNumMainStart pageNumMainEnd))
			(set! pageNumMain ( MSK-getIntStrAt0Head (+(- selfPageNum pageNumMainStart ) 1) 3))
		)
		(string-append ;( MSK-scaleXcfImage imageID width height)
			filePrefix 
			"_v"
			version
			state
			"_"
			pageType
			pageNumMain
			"_"
			( MSK-getIntStrAt0Head selfPageNum 3)
			"_"
			( MSK-getIntStrAt0Head pageNum 3)
			".xcf"
		)
	)
)
)
;--------------------------------------------------最適化済みの処理
;紙のサイズ：紙サイズ横、縦、仕上げ横、縦、内枠のサイズ：横、縦　外枠のサイズ：横、縦　断ち切り幅
(define ( MSK-getTrueSizeAtOptimized imageID paperSize tergetDPI optimizedLeve) 
	(let* (
			(nowWidth  ( MSK-getImageWidth imageID ) )
			(nowHeight  ( MSK-getImageHeight imageID ) )
			(nowRatio ( MSK-getImageRatio imageID ) )
			(sizeList ( MSK-getMangaPaperUnit paperSize))
			(paperSizeWidth (MSK-string2number(MSK-getValueByIndex sizeList 0)))
			(paperSizeHeight (MSK-string2number(MSK-getValueByIndex sizeList 1)))
			(optWitdh  ( MSK-comvertMM2PixcelSizeByDPI paperSizeWidth  tergetDPI))
			(optHeight ( MSK-comvertMM2PixcelSizeByDPI paperSizeHeight tergetDPI))
			(optRatio (/ optHeight optWitdh))
			(offsetX 0)
			(offsetY 0)
			(newWidth 0)
			(newHeigth 0)
			(paperInnerCutSizeWidth (MSK-string2number(MSK-getValueByIndex sizeList 4)))
			(paperInnerCutSizeHeight (MSK-string2number(MSK-getValueByIndex sizeList 5)))
			(optInnerCutWitdh  ( MSK-comvertMM2PixcelSizeByDPI paperInnerCutSizeWidth  tergetDPI))
			(optInnerCutHeight ( MSK-comvertMM2PixcelSizeByDPI paperInnerCutSizeHeight tergetDPI))
			(offsetXPaI (/ (- optWitdh optInnerCutWitdh ) 2 ))
			(offsetYPaI (/ (- optHeight optInnerCutHeight ) 2 ))
		)
		(if (> optimizedLeve 0)
			(begin
				(if (> nowRatio optRatio)
					(begin
						(set! newWidth optWitdh)
						(set! newHeigth (* nowHeight (/ optWitdh nowWidth)))
						(set! offsetX 0)
						(set! offsetY (/ (- optHeight newHeigth) 2))
					)
					(begin
						(set! newWidth  (* nowWidth (/ optHeight nowHeight)))
						(set! newHeigth optHeight)
						(set! offsetX (/ (- optWitdh newWidth) 2))
						(set! offsetY 0)
					)
				)
				( MSK-scaleXcfImage imageID newWidth newHeigth )
				( MSK-resizeImage imageID optWitdh optHeight offsetX offsetY)
			)
			(begin
				( MSK-scaleXcfImage imageID optWitdh optHeight )
			)
		)
		( MSK-setDPI imageID tergetDPI)
		( MSK-resizeImage imageID optInnerCutWitdh optInnerCutHeight offsetXPaI offsetYPaI)
	)
)
;--------------------------------------------------取り合えず、ファイル名をGetする。
(define ( MSK-saveImageAsAFile_Type imageID width heightfilePrefix count pageNum pageNumMainStart pageNumMainEnd pageType version rev ext) 
	(let* (
		 	(fileName ( MSK-makeMangaPageFileNameWithExtention filePrefix count pageNum pageNumMainStart pageNumMainEnd pageType version rev ext))
		 	(nowratio ( MSK-getImageRatio imageID ) )
		 	(layerID (MSK-getValueByIndex ( MSK-getLayersIDList imageID ) 0))
		 	(widthNew  width)
		 	(heightNew height)
		)
		
		(if (> 1 nowratio)
			(set! heightNew (* ( MSK-getImageHeight imageID ) (/ width ( MSK-getImageWidth imageID ))))
			(set! widthNew  (* ( MSK-getImageWidth imageID ) (/ height ( MSK-getImageHeight imageID ))))
		)
		( MSK-scaleXcfImage imageID widthNew heightNew)
		(if (equal? "xcf" ext)
			( MSK-saveXcfImage imageID fileName) 
		)
		
		(if (equal? "png" ext)
			( file-png-save-defaults non-interactive imageID layerID fileName fileName) 
		)
		(if (equal? "jpg" ext)
			( file-jpeg-save non-interactive imageID layerID fileName fileName 0.8 1 1 "mansiki" 0 1 0 1) 
		)
	)
)
;--------------------------------------------------取り合えず、ファイル名をGetする。
(define ( MSK-setMPnodoMainPage ImageID paparSize selfPageNum startSide) 
	(let* (
			(selfSide ( MSK-getSelfSide selfPageNum startSide ))
			(nowWidth  ( MSK-getImageWidth imageID ) )
			(nowHeight  ( MSK-getImageHeight imageID ) )
			(nowRatio ( MSK-getImageRatio imageID ) )
			(sizeList ( MSK-getPaperUnit paperSize))
			(paperSizeWidth (MSK-string2number(MSK-getValueByIndex sizeList 0)))
			(paperSizeHeight (MSK-string2number(MSK-getValueByIndex sizeList 1)))
			(offsetX (- paperSizeWidth nowWidth))
			(offsetY (- paperSizeHeight nowHeight))
		)
		(if (equal? selfSide "left")
			(begin
				(set! offsetX offsetX)
				(set! offsetY (/ offsetY 2)) 
			)
			(begin
				(set! offsetX 0)
				(set! offsetY (/ offsetY 2)) 
			)
		)
		( MSK-resizeImage imageID paperSizeWidth paperSizeHeight offsetX offsetY)
		( MSK-setDPI imageID tergetDPI)
	)
)
;--------------------------------------------------取り合えず、ファイル名をGetする。
(define ( MSK-getMansikiNameByFile_Type typeprefix ImageID No) 
	(let* (
			(isManski ( MSK-getIsMansikiMPfile ImageID))
		)	
		(if (eqv? 1 isManski)
			(begin 
				(fileName ( MSK-makeMangaPageFileName filePrefix selfPageNum pageNum pageNumMainStart pageNumMainEnd pageType version state))
			)
		)
	)
)
;--------------------------------------------------Manskiファイルか識別
(define ( MSK-getIsMansikiMPfile ImageID) 
	(let* (
			(title ( MSK-getTitleParasite imageID ))
			(filePrefix ( MSK-getFilePrefixParasite imageID ))
		)
		(if (and 
				(not (equal? filePrefix ""))
				(not (equal? title ""))
				)
			TRUE
			FALSE
		)
	)
)

;--------------------------------------------------
(script-fu-register "Mansiki-ComvertImage"
		    "Mansiki-ComvertImage(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2008/11/08"
		    "GPL"
	) 
(script-fu-menu-register "Mansiki-ComvertImage"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
