; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-Layer ) 
	(gimp-message  "Layer")
	
)
;--------------------------------------------------レイヤー?
(define ( MSK-isLayer layerID ) 
	(gimp-drawable-is-layer layerID)
)
;--------------------------------------------------フローター?
(define ( MSK-isFloatingSel layerID ) 
	(gimp-layer-is-floating-sel layerID)
)
;--------------------------------------------------フローター?ならレイヤーに転換
(define ( MSK-convertFloatingSel2Layer layerID ) 
	(if ( MSK-isFloatingSel layerID ) 
		(gimp-floating-sel-to-layer layerID)
	)
)
;--------------------------------------------------LayerIDからImageIDの逆引き
(define ( MSK-getImageIDByLayerID layerID ) 
	(let* (
			(imageIDList (vector->list(MSK-getValueByIndex (gimp-image-list)1) ))
			(imageIDCount (MSK-count imageIDList))
			(resultImageID -1)
			(currentImageID -1)
		)
        (while (> imageIDCount 0)
        	(set! currentImageID (MSK-getValueByIndex imageIDList (- imageIDCount 1)))
        	(if (eqv? (MSK-hasTheLayerOnImage currentImageID layerID) 1)
        		(begin 
        			(set! resultImageID currentImageID )
        			(set! imageIDCount 0)
        		)
        	)
            (set! imageIDCount (- imageIDCount 1))
        )
        resultImageID
	)
)
;--------------------------------------------------対象のイメージに指定のレイヤーがあるか判定
(define ( MSK-hasTheLayerOnImage imageID layerID) 
	(MSK-hasElement ( MSK-getLayersIDList imageID ) layerID)
)

;--------------------------------------------------サイズが同じRGBの乗算レイヤーを作成
(define ( MSK-newLayer imageID ) 
	(let* (
			(newLayer 0)
			(bg-color '(255 255 255))  
			
		)
		(set! newLayer (MSK-getValueByIndex (gimp-layer-new imageID 1 1  1 "new layer" 100 3 ) 0))
		(gimp-image-add-layer imageID newLayer -1)
		(gimp-layer-resize-to-image-size newLayer)
		;(gimp-drawable-fill newLayer BACKGROUND-FILL)
		(gimp-context-set-background bg-color)
		(gimp-palette-set-background bg-color)
		;(gimp-context-set-gradient)
		;(gimp-drawable-fill newLayer BG-IMAGE-FILL)
		;(gimp-edit-fill newLayer WHITE-IMAGE-FILL)
		(gimp-drawable-fill newLayer TRANS-IMAGE-FILL)
		newLayer
	)
)
;--------------------------------------------------レイヤーを削除
(define ( MSK-deleteLayer layerID ) 
	;(MSK-first(gimp-layer-delete layerID))
	(gimp-image-remove-layer ( MSK-getImageIDByLayerID layerID ) layerID)
)
;--------------------------------------------------レイヤーをコピー
(define ( MSK-copyLayer  layerID ) 
	(let* (
			(newLayer 0)
		)
		(set! newLayer (MSK-first(gimp-layer-copy layerID FALSE)))
		(gimp-image-add-layer ( MSK-getImageIDByLayerID layerID ) newLayer -1)
		newLayer
	)
)
;--------------------------------------------------レイヤーを別の画像にコピー
(define ( MSK-copyLayerToTheImage imageID layerID ) 
	(let* (
			(newImageID ( MSK-copyImage ( MSK-getImageIDByLayerID layerID ) ))
			(layerName ( MSK-getLayerName layerID ))
			(newLayer (MSK-getLayerIDByName newImageID layerName))
			(copyLayer 0)
			(tempImageFileName "test.png")
		)
		(MSK-deleteLayerNoIDOnTheList newImageID (list newLayer))
		( MSK-saveImageByExt newImageID tempImageFileName) 
		(set! copyLayer ( MSK-loadAsLayer tempImageFileName imageID) )
		(gimp-image-delete newImageID)
		( MSK-setLayerName copyLayer layerName) 
		( MSK-setOpacityLayer copyLayer ( MSK-getOpacityLayer layerID) )
		( MSK-setModeLayer copyLayer  ( MSK-getModeLayer layerID) )
		copyLayer
	)
)
;--------------------------------------------------レイヤーをイメージ間移動
(define ( MSK-moveLayer newImageID layerID ) 
	(let* (
			(newLayer 0)
		)
		(set! newLayer ( MSK-copyLayerToTheImage newImageID layerID ) )
		( MSK-deleteLayer layerID )
		newLayer
	)
)
;--------------------------------------------------レイヤーをイメージからロード
(define ( MSK-loadAsLayer fileName newImageID) 
	(let* (
			(newLayer (MSK-first(vector->list(MSK-getValueByIndex(gimp-file-load-layers 1 newImageID fileName ) 1))))
		)
		(gimp-image-add-layer newImageID newLayer -1)
		( MSK-setLayerName newLayer "loadLayer") 
		newLayer
	)
)
;--------------------------------------------------名前取得
(define ( MSK-getLayerName layerID ) 
	(MSK-first(gimp-layer-get-name layerID ))
)
;--------------------------------------------------名前からID取得
(define ( MSK-getLayerIDByName imageID name) 
	(let* (
			(resultLayerID -1)
			(layerIDList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDList ))
			(currentLayerName "")
			(currentLayerID "")
			(resultLayerID -1)
		)
        (while (> layerCount 0)
        	(set! currentLayerID (MSK-getValueByIndex layerIDList (- layerCount 1)))
        	(set! currentLayerName ( MSK-getLayerName currentLayerID ))
            (if(equal? currentLayerName name)
            	(begin 
            		(set! layerCount 0)
            		(set! resultLayerID currentLayerID)
            	)
            )
            (set! layerCount (- layerCount 1))
        )
        resultLayerID
	)
)
;--------------------------------------------------名前設定:
(define ( MSK-setLayerName layerID newName) 	
	(if (MSK-first(gimp-layer-set-name layerID newName))
		newName
		""
	)
)
;--------------------------------------------------付透明度取得
(define ( MSK-getModeLayer layerID) 
	(MSK-first(gimp-layer-get-mode layerID))
)
;--------------------------------------------------付透明度設定 NORMAL-MODE (0), DISSOLVE-MODE (1), BEHIND-MODE (2), MULTIPLY-MODE (3), SCREEN-MODE (4), OVERLAY-MODE (5), DIFFERENCE-MODE (6), ADDITION-MODE (7), SUBTRACT-MODE (8), DARKEN-ONLY-MODE (9), LIGHTEN-ONLY-MODE (10), HUE-MODE (11), SATURATION-MODE (12), COLOR-MODE (13), VALUE-MODE (14), DIVIDE-MODE (15), DODGE-MODE (16), BURN-MODE (17), HARDLIGHT-MODE (18), SOFTLIGHT-MODE (19), GRAIN-EXTRACT-MODE (20), GRAIN-MERGE-MODE (21), COLOR-ERASE-MODE (22), ERASE-MODE (23), REPLACE-MODE (24), ANTI-ERASE-MODE (25) }
(define ( MSK-setModeLayer layerID mode) 
	(MSK-first(gimp-layer-set-mode layerID mode))
)
;--------------------------------------------------付透明度取得
(define ( MSK-getOpacityLayer layerID) 
	(MSK-first(gimp-layer-get-opacity layerID))
)
;--------------------------------------------------付透明度設定
(define ( MSK-setOpacityLayer layerID opacity) 
	(MSK-first(gimp-layer-set-opacity layerID opacity))
)
;--------------------------------------------------最上部に設定
(define ( MSK-topZindexLayer layerID ) 
	(MSK-first(gimp-image-raise-layer-to-top ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------最上部に設定
(define ( MSK-bottomZindexLayer layerID ) 
	(MSK-first(gimp-image-lower-layer-to-bottom ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------一つ上に設定する
(define ( MSK-upZindexLayer layerID ) 
	(MSK-first(gimp-image-raise-layer ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------一つ下に設定する
(define ( MSK-downZindexLayer layerID ) 
	(MSK-first(gimp-image-lower-layer ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------現在のレイヤーの位置を取得(0始まり上からの順番)
(define ( MSK-getZindexLayer  layerID ) 
	(MSK-first(gimp-image-get-layer-position ( MSK-getImageIDByLayerID layerID ) layerID))
)
;--------------------------------------------------レイヤーのIDリストゲット
(define ( MSK-getLayersIDListSortedByZindex imageID ) 
	(vector->list(MSK-getValueByIndex (gimp-image-get-layers imageID ) 1))
)
;--------------------------------------------------レイヤーのIDリストゲットこれは既に上からの順番で出力される。
(define ( MSK-getLayersIDList imageID ) 
	(vector->list(MSK-getValueByIndex (gimp-image-get-layers imageID ) 1))
)
;--------------------------------------------------レイヤーのアクティブ化
(define ( MSK-setActiveLayer layerID ) 
	(if ( MSK-isLayer layerID ) 
	 	(gimp-image-set-active-layer ( MSK-getImageIDByLayerID layerID ) layerID)
	)
)
;--------------------------------------------------レイヤーのIDリスト順にレイヤーをソート
(define ( MSK-sortLayerZindexByNameList imageID layerNameList ) 
	(let* (
			(resultLayerID -1)
			(layerIDList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDList ))
			(nameCount ( MSK-count layerNameList ))
			(currentLayerName "")
			(currentLayerID "")
			(resultLayerID "")
			(currentName "")
			(resultNotMatchLayerID ())
			(layerCountAll layerCount)
		)
        (while (> nameCount 0)
			(set! currentName (MSK-getValueByIndex layerNameList (- nameCount 1)))
		    (while (> layerCount 0)
		    	(set! currentLayerID (MSK-getValueByIndex layerIDList (- layerCount 1)))
		    	(set! currentLayerName ( MSK-getLayerName currentLayerID ))
		        (if(equal? currentLayerName currentName)
		        	(begin 
		        		(set! layerCount 0)
		        		(MSK-topZindexLayer currentLayerID ) 
		        	)
		        )
		        (set! layerCount (- layerCount 1))
		    )
			(set! layerCount  layerCountAll)
			(set! nameCount (- nameCount 1))
        )
	)
)
;--------------------------------------------------レイヤーのIDリストにないレイヤーを削除
(define ( MSK-deleteLayerNoNameOnTheList imageID layerNameList ) 
	(let* (
			(resultLayerID -1)
			(layerIDList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDList ))
			(nameCount ( MSK-count layerNameList ))
			(currentLayerName "")
			(currentLayerID "")
			(resultLayerID "")
			(currentName "")
			(resultNotMatchLayerID ())
			(delFlag 2)
			(layerCountAll nameCount)
		)
	    (while (> layerCount 0)
	    	(set! delFlag 2)
	    	(set! currentLayerID (MSK-getValueByIndex layerIDList (- layerCount 1)))
	    	(set! currentLayerName ( MSK-getLayerName currentLayerID ))
	    	
		    (while (> nameCount 0)
				(set! currentName (MSK-getValueByIndex layerNameList (- nameCount 1)))
			    (if(equal? currentLayerName currentName)
			    	(begin 
			    		(set! nameCount 0)
			    		(set! delFlag FALSE)
			    	)
			    )
				(set! nameCount (- nameCount 1))
		    )
		    (if (eqv? delFlag 2)
		    	(MSK-deleteLayer currentLayerID)
		    )
			(set! nameCount  layerCountAll)
	        (set! layerCount (- layerCount 1))
	    )
	    delFlag
	)
)
;--------------------------------------------------レイヤーのIDリストにないレイヤーを削除
(define ( MSK-deleteLayerNoIDOnTheList imageID layerIDList ) 
	(let* (
			(resultLayerID -1)
			(layerIDALLList ( MSK-getLayersIDList imageID ))
			(layerCount ( MSK-count layerIDALLList ))
			(IDCount ( MSK-count layerIDList ))
			(currentLayerID "")
			(resultLayerID "")
			(currentID "")
			(resultNotMatchLayerID ())
			(delFlag 2)
			(layerCountAll IDCount)
		)
	    (while (> layerCount 0)
	    	(set! delFlag 2)
	    	(set! currentLayerID (MSK-getValueByIndex layerIDALLList (- layerCount 1)))
	    	
		    (while (> IDCount 0)
				(set! currentID (MSK-getValueByIndex layerIDList (- IDCount 1)))
			    (if(eqv? currentLayerID currentID)
			    	(begin 
			    		(set! IDCount 0)
			    		(set! delFlag 0)
			    	)
			    )
				(set! IDCount (- IDCount 1))
		    )
		    (if (eqv? delFlag 2)
		    	(MSK-deleteLayer currentLayerID)
		    )
			(set! IDCount  layerCountAll)
	        (set! layerCount (- layerCount 1))
	    )
	    delFlag
	)
)
;--------------------------------------------------レイヤー数ゲット
(define ( MSK-getLayersCount imageID ) 
	(MSK-first (gimp-image-get-layers imageID ) )
)
;--------------------------------------------------レイヤー幅ゲット
(define ( MSK-getLayerWidth  layerID)　
	(MSK-first (gimp-drawable-width layerID))
)
;--------------------------------------------------レイヤー高さゲット
(define ( MSK-getLayerHeight layerID) 
	(MSK-first (gimp-drawable-height layerID))
)
;--------------------------------------------------レイヤー幅セット
(define ( MSK-setLayerWidth  layerID newWidth) 
	(gimp-layer-resize layerID
		newWidth
		( MSK-getLayerHeight layerID) 
		( MSK-getOffsetX  layerID)
		( MSK-getOffsetY  layerID)
	)
)
;--------------------------------------------------レイヤー高さセット
(define ( MSK-setLayerHeight layerID newHeight) 
	(gimp-layer-resize layerID
		( MSK-getLayerWidth layerID) 
		newHeight
		( MSK-getOffsetX  layerID)
		( MSK-getOffsetY  layerID)
	)
)
;--------------------------------------------------レイヤーoffsetX
(define ( MSK-getOffsetX  layerID) 
	(MSK-getValueByIndex (gimp-drawable-offsets layerID) 0)
)
;--------------------------------------------------レイヤーoffsetY
(define ( MSK-getOffsetY  layerID) 
	(MSK-getValueByIndex (gimp-drawable-offsets layerID) 1)
)
;--------------------------------------------------レイヤーoffsetX設定
(define ( MSK-setOffsetX  layerID newOffsetX) 
	(gimp-layer-set-offsets layerID newOffsetX ( MSK-getOffsetY layerID))
)
;--------------------------------------------------レイヤーoffsetY設定
(define ( MSK-setOffsetY  layerID newOffsetY) 
	(gimp-layer-set-offsets layerID ( MSK-getOffsetX layerID) newOffsetY)
)
;--------------------------------------------------レイヤーoffsetXレイヤーoffsetY
(define ( MSK-getLayerOffsetLocationByName imageID layerName) 
	(let* (
			(layerID ( MSK-getLayerIDByName imageID layerName))
		)
		(if (> layerID -1)
			(list ( MSK-getOffsetX  layerID) ( MSK-getOffsetY  layerID))
			(list 0 0)
		)
	)
)


;--------------------------------------------------レイヤー幅セット
(define ( MSK-scaleLayer  layerID newScale) 
	(gimp-layer-scale layerID
		(* ( MSK-getLayerWidth layerID) newScale) 
		(* ( MSK-getLayerHeight layerID) newScale) 
		TRUE
	)
)
;--------------------------------------------------レイヤー見えてる？
(define ( MSK-isVisibleLayer  layerID) 
	(MSK-first (gimp-layer-get-visible layerID))
)
;--------------------------------------------------レイヤー見える設定
(define ( MSK-setInvisibleLayer  layerID) 
	(MSK-first (gimp-layer-set-visible layerID FALSE ))
)
;--------------------------------------------------レイヤー見えない設定
(define ( MSK-setVisibleLayer  layerID) 
	(MSK-first (gimp-layer-set-visible layerID TRUE))
)
;--------------------------------------------------レイヤーロックしてる？
(define ( MSK-isLockedLayer  layerID) 
	(MSK-first (gimp-layer-get-linked layerID))
)
;--------------------------------------------------レイヤーロック設定
(define ( MSK-setLockLayer  layerID) 
	(MSK-first (gimp-layer-set-linked layerID TRUE))
)
;--------------------------------------------------レイヤーロックしない設定
(define ( MSK-setUnLockLayer  layerID) 
	(MSK-first (gimp-layer-set-linked layerID FALSE))
)
;--------------------------------------------------レイヤーに色をつける
(define ( MSK-fillLayerColor  layerID color) 
	(let* (
			(currentBackground (MSK-first(gimp-context-get-background)))
		)
		(gimp-context-set-background color)
		(gimp-drawable-fill layerID BACKGROUND-FILL)
		(gimp-context-set-background currentBackground)
	)
)
;--------------------------------------------------レイヤーを回転
(define ( MSK-rotateLayer  layerID angle) 
	(let* (
			(rotateAngle (* (* 2 *pi*) (/ angle 360 )))
		)
		(gimp-drawable-transform-rotate-default layerID rotateAngle TRUE 
			( MSK-getOffsetX  layerID) 
			( MSK-getOffsetY  layerID)
			TRUE
			TRANSFORM-RESIZE-ADJUST
		)
	)
)
;--------------------------------------------------レイヤーを結合By名前
(define ( MSK-mergeLayerByName imageID layerNamesList) 
	(let* (
			(count (MSK-count layerNamesList))
			(layerIDsList '())
			(currentLayerID -1)
			(name "")
		)
		(while (> count 0)
			(set! count (- count 1))
			(set! name (MSK-getValueByIndex layerNamesList count))
			(set! currentLayerID (MSK-getLayerIDByName imageID name))
			(if (> currentLayerID 0)
				(set! layerIDsList (MSK-push layerIDsList currentLayerID))
			)
		)
		count
		(MSK-mergeLayer layerIDsList)
	)
)
;--------------------------------------------------レイヤーを結合ByIDで、一番最初に存在するレイヤーのイメージが処理対象。
(define ( MSK-mergeLayer layerIDsList) 
	(let* (
			(imageID -1)
			(layerList '())
			(countPre -1)
			(count -1)
			(visibleList '())
			(otherLayerList '())
			(currentLayerID -1)
			(stringA "none")
			(newLayerID -1)
			(viewLayerIDCount -1)
		)
		(set! countPre (MSK-count layerIDsList))
		(while (> countPre 0)
			(set! countPre (- countPre 1))
			(set! currentLayerID (MSK-getValueByIndex layerIDsList countPre))
			(if (> currentLayerID 1 )
				(begin 
					(set! imageID ( MSK-getImageIDByLayerID currentLayerID))
					(set! layerList (MSK-getLayersIDList imageID))
					(set! count (MSK-count layerList))
					(set! countPre 0)
				)
			)
		)
		(if (> imageID 0)
			(begin 
				(while (> count 0)
					(set! count (- count 1))
					(set! currentLayerID (MSK-getValueByIndex layerList count))
					(if (eqv? ( MSK-hasElement layerIDsList currentLayerID) 0 )
						(begin 
		;(set! stringA (string-append stringA " = " (number->string ( MSK-hasElement layerIDsList currentLayerID)) "/" (number->string count) "/" (number->string currentLayerID)))
							(if ( MSK-isVisibleLayer  currentLayerID)
								(begin  
									( MSK-setInvisibleLayer  currentLayerID) 
									(set! visibleList (MSK-push visibleList 1))
								)
								(set! visibleList (MSK-push visibleList 0))
							)
							(set! otherLayerList (MSK-push otherLayerList currentLayerID))
						)
					)
				)
				(set! count (MSK-count layerIDsList))
				(while (> count 0)
					(set! count (- count 1))
					(set! currentLayerID (MSK-getValueByIndex layerIDsList count))
		;(set! stringA (string-append stringA " = " (number->string viewLayerIDCount) "/"(number->string ( MSK-hasElement layerList currentLayerID)) "/" (number->string count) "/" (number->string currentLayerID)))

					(if (eqv? ( MSK-hasElement layerList currentLayerID) 1 )
						(begin 
							( MSK-setVisibleLayer  currentLayerID) 
							(set! viewLayerIDCount 2)
						)
					)
				)
				(if (> viewLayerIDCount 0)
					(set! newLayerID (MSK-first (gimp-image-merge-visible-layers imageID EXPAND-AS-NECESSARY)))
				)
				(if (> newLayerID 0 )
					( MSK-setVisibleLayer newLayerID) 
				)
				(set! count (MSK-count otherLayerList))
				(while (> count 20)
					(set! count (- count 1))
					(set! currentLayerID (MSK-getValueByIndex otherLayerList count))
					(if  (eqv? (MSK-getValueByIndex visibleList count) 1)
						( MSK-setVisibleLayer  currentLayerID) 
					)
				)
			)
		)
		newLayerID
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-Layer"
		    "Mansiki-Layer(Lib)"
		    "Mansiki"
		    "name"
		    "Rongfu"
		    "2008/06/09"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-Layer"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
