; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-BuildMPGuideLayer ) 
	(gimp-message  "BuildMPGuideLayer")
	
)
;--------------------------------------------------四捨五入：桁溢れが気になる
(define ( MSK-buildMPGuideLayer
		imageID
		title
		filePrefix
		pageNum
		pageNumMainStart
		pageNumMainEnd
		paperSize
		targetDPI
		monitorSizeX
		monitorSizeY
		optimazingLevel2MonitorSize
		startSide
		pageFlowDirection
		selfPageNum
		author
		license
		insertDateTime
		updateDateTime
		version
		)
	(let* (
			(settingHash ( MSK-loadMPGuidInfoSetting ) )
			(pageType ( MSK-getMPtype selfPageNum pageNumMainStart pageNumMainEnd))
			(selfSide ( MSK-getSelfSideParasite imageID ))
			(layers4Merge '())
			(mergedLayerID -1)
			(whiteLayerID -1)
			(mainSelfPageNum (+ 1 (- selfPageNum pageNumMainStart )))
			(mainPageNum (+ 1 (- pageNumMainEnd pageNumMainStart )))
			(sizeRatio ( MSK-getPaperSizeRatio paperSize "B5"))
			(nowContextColor (MSK-getValueByIndex (gimp-context-get-foreground )0))
			(fontSettingColor (list 255 0 0 ))
		)
		(gimp-message "buildMPGuideLayer 001" )
		(if (equal? "Main_" pageType)
			(begin 
				(gimp-message "buildMPGuideLayer 001A1" )
				(gimp-context-set-foreground fontSettingColor)
				(if (equal? "right" selfSide)
					(begin 
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID title 			sizeRatio ( MSK-getValueFromHash settingHash "title1R") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID title 			sizeRatio ( MSK-getValueFromHash settingHash "title2R") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID 
							(string-append (number->string monitorSizeX) "x" (number->string monitorSizeY)) sizeRatio ( MSK-getValueFromHash settingHash "monitorSizeR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID paperSize 		sizeRatio ( MSK-getValueFromHash settingHash "paperSizeR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID selfSide 			sizeRatio ( MSK-getValueFromHash settingHash "selfSideR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID author 			sizeRatio ( MSK-getValueFromHash settingHash "authorR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID license 			sizeRatio ( MSK-getValueFromHash settingHash "licenseR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID insertDateTime 	sizeRatio ( MSK-getValueFromHash settingHash "insertDateTimeR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID updateDateTime 	sizeRatio ( MSK-getValueFromHash settingHash "updateDateTimeR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID version 			sizeRatio ( MSK-getValueFromHash settingHash "versionR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID 
							(string-append (number->string selfPageNum) "/" (number->string pageNum) ) sizeRatio ( MSK-getValueFromHash settingHash "pageNumR") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID 
							(string-append (number->string mainSelfPageNum) "/" (number->string mainPageNum) ) sizeRatio ( MSK-getValueFromHash settingHash "pageNumR2") )))
					)
				)
				(gimp-message "buildMPGuideLayer 001A2" )
				(if (equal? "left" selfSide)
					(begin 
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID title 			sizeRatio ( MSK-getValueFromHash settingHash "title1L") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID title 			sizeRatio ( MSK-getValueFromHash settingHash "title2L") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID 
							(string-append (number->string monitorSizeX) "x" (number->string monitorSizeY)) sizeRatio ( MSK-getValueFromHash settingHash "monitorSizeL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID paperSize 		sizeRatio ( MSK-getValueFromHash settingHash "paperSizeL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID selfSide 			sizeRatio ( MSK-getValueFromHash settingHash "selfSideL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID author 			sizeRatio ( MSK-getValueFromHash settingHash "authorL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID license 			sizeRatio ( MSK-getValueFromHash settingHash "licenseL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID insertDateTime 	sizeRatio ( MSK-getValueFromHash settingHash "insertDateTimeL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID updateDateTime 	sizeRatio ( MSK-getValueFromHash settingHash "updateDateTimeL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID version 			sizeRatio ( MSK-getValueFromHash settingHash "versionL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID 
							(string-append (number->string selfPageNum) "/" (number->string pageNum) ) sizeRatio ( MSK-getValueFromHash settingHash "pageNumL") )))
						(set! layers4Merge(MSK-push layers4Merge( MSK-makeInfoRasterLayerByCSVrow imageID 
							(string-append (number->string mainSelfPageNum) "/" (number->string mainPageNum) ) sizeRatio ( MSK-getValueFromHash settingHash "pageNumL2") )))
					)
				)
				
				(gimp-message "buildMPGuideLayer 001A3" )
				(if (> (MSK-count layers4Merge) 0)
					(begin
						(gimp-context-set-foreground nowContextColor);色元に戻す
						(set! whiteLayerID( MSK-newLayer imageID ))
						( MSK-fillLayerColor  whiteLayerID '(255 255 255))
						( MSK-bottomZindexLayer whiteLayerID )
						(set! layers4Merge(MSK-push layers4Merge whiteLayerID ))
						(set! mergedLayerID( MSK-mergeLayer layers4Merge))
						( MSK-setOpacityLayer mergedLayerID 30) 
						( MSK-setModeLayer mergedLayerID MULTIPLY-MODE) ;乗算にしとく
					)
	
				)
				(gimp-message "buildMPGuideLayer 001A4" )
			)
		)
		(gimp-message "buildMPGuideLayer 002" )
		mergedLayerID
	)
)
;--------------------------------------------------設定ファイルを読み込み
(define ( MSK-loadMPGuidInfoSetting ) 
	( MSK-getBigSectHash "MPInfoLayer") 
)

;--------------------------------------------------設定ファイルに設定が有れば作成
(define ( MSK-makeInfoRasterLayerByCSVrow imageID text sizeRatio settingCSVrow) 
	(if (not (equal? "" settingCSVrow))
		( MSK-makeInfoRasterLayerByList imageID text sizeRatio (MSK-split settingCSVrow ","))
	)
)
;--------------------------------------------------リスと入力版
(define ( MSK-makeInfoRasterLayerByList imageID text sizeRatio settingList) 
	( MSK-makeInfoRasterLayer imageID text 
		(number->string (* sizeRatio (MSK-string2number(MSK-getValueByIndex settingList 0))));size
		(MSK-getValueByIndex settingList 1);font
		(* sizeRatio (MSK-string2number (MSK-getValueByIndex settingList 2)));offsetX
		(* sizeRatio (MSK-string2number (MSK-getValueByIndex settingList 3)));offsetY
		(MSK-string2number (MSK-getValueByIndex settingList 4));angle
	) 
)
;--------------------------------------------------実際のラスターレイヤー作成処理
(define ( MSK-makeInfoRasterLayer imageID text size font offsetX offsetY angle) 
	(let* (
			(newLayerID -1)
		)
		(set! newLayerID( MSK-makeTextLayerAntiAlias imageID text size font))
		;(set! newLayerID ( MSK-comvertToRaster newLayerID ))
		( MSK-rotateLayer newLayerID angle) 
		( MSK-setOffsetX  newLayerID offsetX)
		( MSK-setOffsetY  newLayerID offsetY)
		newLayerID
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-BuildMPGuideLayer"
		    "Mansiki-BuildMPGuideLayer(Lib)"
		    "Mansiki"
		    "name"
		    "Rongfu"
		    "2008/08/03"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-BuildMPGuideLayer"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
