;;Batch image size convert Script-Fủǔ http://sourceforge.jp/projects/mansiki/
;;Ronfu
;;05/07/2007
;;This code is under the GPLS

;;Convert a imageSize to aSize of paper @ JIS
;--------------------------------------------------
(define (resize-PaperSize image 
					direction 
					resolution
					paperSize)
					
	(gimp-selection-all image)

	; Retrieve the current dimensions of the image
	(define mansiki-selection-bounds (gimp-selection-bounds image))
	(define mansiki-x1 (cadr mansiki-selection-bounds))
	(define mansiki-y1 (caddr mansiki-selection-bounds))
	(define mansiki-x2 (- (cadr (cddr mansiki-selection-bounds)) mansiki-x1))
	(define mansiki-y2 (- (caddr (cddr mansiki-selection-bounds)) mansiki-y1))

	; De-select the selection
	(gimp-selection-none image)


	(let* (
			(currentWidth (- mansiki-x2 mansiki-x1))
			(currentHeigth (- mansiki-y2 mansiki-y1))
			(paperSizeWidth 0)
			(paperSizeHeight 0)
			(newWidthPixcels 0)
			(newHeightPixcels 0)
			(maxSize 0)
			(ratioX 0)
			(ratioY 0)
			(ratioALL 0)
		)
		(papaerSizeData (getPaperSize direction resolution paperSize))
		(set! paperSizeWidth (aref papaerSizeData 1))
		(set! paperSizeHeight (aref papaerSizeData 2))
		
		(set! retioX (/ paperSizeWidth currentWidth))
		(set! retioY (/ paperSizeHeight currentHeigth))
		
		(set! ratioALL retioX)
		(if (>= ratioX ratioY)
			(set! ratioALL retioY)
		)
		
		(set! newWidthPixcels (* currentWidth ratioALL))
		(set! newHeightPixcels (* currentHeigth ratioALL))
		
		(gimp-drawable-transform-scale drawable 0 0 newWidthPixcels newHeightPixcels TRANSFORM-FORWARD INTERPOLATION-CUBIC 1 3 0)
		(gimp-image-resize image newWidthPixcels newHeightPixcels 0 0) 
		(gimp-image-set-resolution image currentDpi currentDpi) 
	
	)
    ; Flush the display to show changes 
    (gimp-displays-flush)
)
;--------------------------------------------------
(define (getPaperSize  
					direction 
					resolution
					paperSize)
					
  (let* 
    (
      ; Calculate current and new width, height, ratio, and step size
	  ; Select the entire image
      (newWidthPixcels  0)
      (newHeightPixcels 0)
      (scaleWidthPixcels  0)
      (scaleHeightPixcels 0)
      (paperWidth 0)
      (paperHeigth 0)
      (currentDpi 0)
    )
    
    (if (= paperSize 1);B5
    	(begin
			(set! paperWidth 182)
			(set! paperHeigth 257)
    	)
    )
    (if (= paperSize 2);A4
    	(begin
			(set! paperWidth 210)
			(set! paperHeigth 297)
    	)
    )
    (if (= paperSize 3);B4
    	(begin
			(set! paperWidth 257)
			(set! paperHeigth 364)
    	)
    )
    (if (= paperSize 4);A3
    	(begin
			(set! paperWidth 297)
			(set! paperHeigth 420)
    	)
    )
    (if (= paperSize 5);t
    	(begin
			(set! paperWidth 100)
			(set! paperHeigth 148)
    	)
    )
    (if (= paperSize 6);R~eBA
    	(begin
			(set! paperWidth 49)
			(set! paperHeigth 49)
    	)
    )
    
    (if (= resolution 1);600dpi
    	(set! currentDpi 600)
    )
    (if (= resolution 2);72dpi
    	(set! currentDpi 72)
    )
    (if (= resolution 3);72dpi
    	(set! currentDpi 72)
    )
    (if (= resolution 4);96dpi
    	(set! currentDpi 96)
    )
    (if (= resolution 5);300dpi
    	(set! currentDpi 300)
    )
    (if (= resolution 6);720dpi
    	(set! currentDpi 720)
    )
    (if (= resolution 7);1200dpi
    	(set! currentDpi 1200)
    )
	
	(if (= direction 1);c
		(set! newWidthPixcels (getPixcelsFromMMAndDpi paperWidth currentDpi))
		(set! newHeightPixcels (getPixcelsFromMMAndDpi paperHeigth currentDpi))
	)
	(if (= direction 2);
		(set! newWidthPixcels (getPixcelsFromMMAndDpi paperHeigth currentDpi))
		(set! newHeightPixcels (getPixcelsFromMMAndDpi paperWidth currentDpi))
	)
	(if (= direction 3);`
		(set! newWidthPixcels (getPixcelsFromMMAndDpi paperHeigth currentDpi))
		(set! newHeightPixcels (getPixcelsFromMMAndDpi paperHeigth currentDpi))
	)
	(list newWidthPixcels newHeightPixcels)
  )
)
;--------------------------------------------------
(define (getPixcelsFromMMAndDpi mMater dpi)
	(let* (
			(x 0)
			(output 0)
		)
      (set! x (/ mMater 25.4))
      (set! output (trunc (* x dpi)));
      output
	)
)

(script-fu-register "resize-PaperSize"
		    _"<Image>/Script-Fu/Mansiki/Resize-PaperSize"
		    "Resize an image by steps"
		    "Rongfu"
		    "GPL"
		    "2007/05/15"
		    ""
		    SF-IMAGE       "Image"         0
			SF-OPTION     _"PaperScale"    '(_"hight Longer" _"width Longer" "cubic(Set Longer Side Value)")
			SF-OPTION     _"dpi Setting"    '(_"600dpi"
											_"72dpi"
											_"96dpi"
											_"300dpi"
											_"720dpi"
											_"1200dpi")
			SF-OPTION     _"PaperSize (mm)"  '(_"B5 182x257"
											_"A4 210x297"
											_"B4 257x364"
											_"A3 297x420"
											_"Hagaki 100x148"
											_"Pixiv 800x800"
											_"Mangaroo 650x460"
											_"Comitia 49x49")
)

