; GIMP Script-Fu Simple-Logo  http://www.geocities.jp/gimproject/gimp2.0.html

(define ( script-fu-simple-logo text size font) 

  (let* ((img (car (gimp-image-new 256 256 RGB)))
          (border (/ size 4))
          (text-layer (car (gimp-text-fontname img -1 0 0 text border TRUE size PIXELS font))) 
          (width (car (gimp-drawable-width text-layer))) 
          (height (car (gimp-drawable-height text-layer))) 
          (bg-layer (car (gimp-layer-new img width height RGBA-IMAGE "背景" 100 NORMAL)))
         )
      (gimp-image-undo-disable img)
      (gimp-image-resize img width height 0 0) 
      (gimp-image-add-layer img bg-layer 1) 
      (gimp-edit-fill bg-layer 1)
      (gimp-image-set-active-layer img text-layer)
      (gimp-image-undo-enable img)
      (gimp-display-new img)
  )
)

(script-fu-register "script-fu-simple-logo"
		    "Simple Logo..."
		    "しんぷる ロゴ"
		    "name"
		    "copyright"
		    "2005/11"
		    ""
		    SF-STRING     _"Text"                "しんぷる ロゴ"
		    SF-ADJUSTMENT _"Font size (pixels)"  '(100 2 1000 1 10 0 1)
		    SF-FONT       _"Font"                "MS PGothic" ) 

(script-fu-menu-register "script-fu-simple-logo"
		    "<Toolbox>/Xtns/Logos")
