/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Table;

class TableDragUnderEffect
extends DragUnderEffect {
    private Table table;
    int scrollIndex;
    private long scrollBeginTime;
    private static final int SCROLL_HYSTERESIS = 150;

    TableDragUnderEffect(Table table) {
        this.table = table;
    }

    private int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public void show(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        int handle = this.table.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = coordinates.x;
        pinfo.y = coordinates.y;
        OS.SendMessage(handle, 4114, 0, pinfo);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (pinfo.iItem != -1 && this.scrollIndex == pinfo.iItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int top = Math.max(0, OS.SendMessage(handle, 4135, 0, 0));
                int count = OS.SendMessage(handle, 4100, 0, 0);
                int index = this.scrollIndex - 1 < top ? Math.max(0, this.scrollIndex - 1) : Math.min(count - 1, this.scrollIndex + 1);
                OS.SendMessage(handle, 4115, index, 0);
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = pinfo.iItem;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.stateMask = 8;
        OS.SendMessage(handle, 4139, -1, lvItem);
        if (pinfo.iItem != -1 && (effect & 1) != 0) {
            lvItem.state = 8;
            OS.SendMessage(handle, 4139, pinfo.iItem, lvItem);
        }
    }
}

