/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets;

import org.eclipse.swt.internal.SWTEventListener;

/**
 * Classes which implement this interface provide methods
 * that deal with the events that are generated in a Marker.
 * <p>
 * After creating an instance of a class that implements
 * this interface it can be added to a control using the
 * <code>addMarkerListener</code> method and removed using
 * the <code>removeMarkerListener</code> method.
 * </p>
 * <p>
 * See Google Maps API documentation [<a href="http://www.google.com/apis/maps/documentation/#GMarker_code_">Class Reference &gt; GMarker &gt; Events</a>].
 * </p>
 *
 * @see MarkerAdapter
 */
public interface MarkerListener extends SWTEventListener {
	/**
	 * Called when the user clicks on the marker.
	 * <p>
	 * See Google Maps API documentation [<a href="http://www.google.com/apis/maps/documentation/#GMarker_code_">Class Reference &gt; GMarker &gt; Events &gt; click</a>].
	 * </p>
	 */
	void clicked();

	/**
	 * Called when the info window is opened above the marker.
	 * <p>
	 * See Google Maps API documentation [<a href="http://www.google.com/apis/maps/documentation/#GMarker_code_">Class Reference &gt; GMarker &gt; Events &gt; infowindowopen</a>].
	 * </p>
	 */
	void infoWindowOpend();

	/**
	 * Called when the info window above the marker is closed.
	 * <p>
	 * See Google Maps API documentation [<a href="http://www.google.com/apis/maps/documentation/#GMarker_code_">Class Reference &gt; GMarker &gt; Events &gt; infowindowclose</a>].
	 * </p>
	 */
	void infoWindowClosed();
}
