/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.sample;

import java.util.Timer;
import java.util.TimerTask;

import jp.sf.mapswidgets.GoogleMaps;
import jp.sf.mapswidgets.Point;


public final class Animate extends GoogleDocumentSample {
	public static void main(String [] arguments) {
		new Animate().run();
	}
	
	private Animate() {
		super("Map Movement and Animation", "http://www.google.com/apis/maps/documentation/#Map_Movement_and_Animation");
	}

	void runScript(final GoogleMaps map) {
		map.setCenter(new Point(-122.1419, 37.4419));
		map.setZoomLevel(4);
		new Timer().schedule(new TimerTask() {
			public void run() {
				map.moveTo(new Point(-122.1569, 37.4569));
			}
		}, 2000);
	}
}
