/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.sample;

import jp.sf.mapswidgets.Bounds;
import jp.sf.mapswidgets.GoogleMaps;
import jp.sf.mapswidgets.Icon;
import jp.sf.mapswidgets.Marker;
import jp.sf.mapswidgets.MarkerAdapter;
import jp.sf.mapswidgets.Point;
import jp.sf.mapswidgets.Size;

public final class CreatingIcons extends GoogleDocumentSample {
	public static void main(String [] arguments) {
		new CreatingIcons().run();
	}
	
	private CreatingIcons() {
		super("Creating Icons", "http://www.google.com/apis/maps/documentation/#Creating_Icons");
	}

	private Icon icon;

	void runScript(GoogleMaps map) {
		// Create our "tiny" marker icon
		icon = new Icon("http://labs.google.com/ridefinder/images/mm_20_red.png", new Size(12, 20), "http://labs.google.com/ridefinder/images/mm_20_shadow.png", new Size(22, 20), new Point(6, 20));
		icon.setOffsetOfInfoWindow(new Point(5, 1));

		// Center the map on Palo Alto.
        map.setSmallMapControlVisible(true);
        map.setMapTypeControlVisible(true);
        map.setCenter(new Point(-122.1419, 37.4419));
        map.setZoomLevel(4);

        // Create one of our tiny markers at the given point.
        // see createMarker(Point, Icon) method

        // Add 10 random markers in the map viewport.
        Bounds bounds = map.getMapBounds();
        double width = bounds.getMaxX() - bounds.getMinX();
        double height = bounds.getMaxY() - bounds.getMinY();
        for (int i = 0; i < 10; i++) {
        	Point point = new Point(bounds.getMinX() + width * Math.random(), bounds.getMinY() + height * Math.random());

        	Marker marker = createMarker(point);
        	map.addOverlay(marker);
        }
	}
	
	// Create one of our tiny markers at the given point.
	private Marker createMarker(Point point) {
        final Marker marker = new Marker(point, icon);
		marker.addMarkerListener(new MarkerAdapter() {
			public void clicked() {
				marker.showInfoWindow("You clicked me!");
			}
		});
		return marker;
	}
}
