/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.sample;

import jp.sf.mapswidgets.GoogleMaps;
import jp.sf.mapswidgets.GoogleMapsAdapter;
import jp.sf.mapswidgets.Point;

public final class Event extends GoogleDocumentSample {
	public static void main(String [] arguments) {
		new Event().run();
	}
	
	private Event() {
		super("Event Listeners", "http://www.google.com/apis/maps/documentation/#Event_Listeners");
	}

	void runScript(final GoogleMaps map) {
		map.addGoogleMapsListener(new GoogleMapsAdapter() {
			public void moveEnded() {
				Point center = map.getCenter();
				String latLngStr = "(" + center.getY() + ", " + center.getX() + ")";
				System.out.println(latLngStr);
			}
		});
		map.setCenter(new Point(-122.1419, 37.4419));
		map.setZoomLevel(4);
	}
}
