package jp.sf.mapswidgets.sample;

import jp.sf.mapswidgets.GoogleMaps;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

abstract class GoogleDocumentSample {
	private final String applicationName;
	private String documentURL;
	
	GoogleDocumentSample(String applicationName, String documentURL) {
		this.applicationName = applicationName;
		this.documentURL = documentURL;
	}
	
	final void run() {
		Display display = new Display();
		final Shell shell = new Shell(display);
		shell.setLayout(new GridLayout());
		shell.setText(applicationName);

		final Link link = new Link(shell, SWT.NONE);
		link.setLayoutData(new GridData());
		link.setText("Related document is <a href=\"" + documentURL + "\">" + documentURL + "</a>.");
		link.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				Program.launch(documentURL);
			}
		});
		
		final GoogleMaps map = new GoogleMaps(shell, SWT.NONE);
		map.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));

		shell.open();

		map.runAfterLoading(new Runnable() {
			public void run() {
				runScript(map);
			}
		});

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}
	
	abstract void runScript(GoogleMaps map);
}
