/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.sample;

import jp.sf.mapswidgets.Bounds;
import jp.sf.mapswidgets.GoogleMaps;
import jp.sf.mapswidgets.Icon;
import jp.sf.mapswidgets.Marker;
import jp.sf.mapswidgets.MarkerAdapter;
import jp.sf.mapswidgets.Point;
import jp.sf.mapswidgets.Size;

public final class IconClass extends GoogleDocumentSample {
	public static void main(String [] arguments) {
		new IconClass().run();
	}
	
	private IconClass() {
		super("Using Icon Classes", "http://www.google.com/apis/maps/documentation/#Using_Icon_Classes");
	}
	
	private Icon baseIcon;

	void runScript(GoogleMaps map) {
		// Create a base icon for all of our markers that specifies the
		// shadow, icon dimensions, etc.
		baseIcon = new Icon();
		baseIcon.setShadowImageURL("http://www.google.com/mapfiles/shadow50.png");
		baseIcon.setImageSize(new Size(20, 34));
		baseIcon.setShadowImageSize(new Size(37, 34));
		baseIcon.setOffsetOfMarker(new Point(9, 34));
		baseIcon.setOffsetOfInfoWindow(new Point(9, 2));

		// Center the map on Palo Alto.
        map.setSmallMapControlVisible(true);
        map.setMapTypeControlVisible(true);
        map.setCenter(new Point(-122.1419, 37.4419));
        map.setZoomLevel(4);

        // Add 10 random markers in the map viewport.
        Bounds bounds = map.getMapBounds();
        double width = bounds.getMaxX() - bounds.getMinX();
        double height = bounds.getMaxY() - bounds.getMinY();
        for (int i = 0; i < 10; i++) {
        	Point point = new Point(bounds.getMinX() + width * Math.random(), bounds.getMinY() + height * Math.random());

        	Marker marker = createMarker(point, i);
        	map.addOverlay(marker);
        }
	}

    // Create a marker whose info window displays the letter corresponding
    // to the given index.
	Marker createMarker(Point point, int index) {
		// Create a lettered icon for this point using our icon class from above
		String letter = Character.toString((char)("A".charAt(0) + index));
		Icon icon = new Icon(baseIcon);
		icon.setImageURL("http://www.google.com/mapfiles/marker" + letter + ".png");
		final Marker marker = new Marker(point, icon);

		// Show this marker's index in the info window when it is clicked.
		final String html = "Marker <b>" + letter + "</b>";
		marker.addMarkerListener(new MarkerAdapter() {
			public void clicked() {
				marker.showInfoWindow(html);
			}
		});
		
		return marker;
	}
}
