/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.sample;

import jp.sf.mapswidgets.GoogleMaps;
import jp.sf.mapswidgets.Point;

public final class InfoWindow extends GoogleDocumentSample {
	public static void main(String [] arguments) {
		new InfoWindow().run();
	}
	
	private InfoWindow() {
		super("Opening an Info Window", "http://www.google.com/apis/maps/documentation/#Opening_an_Info_Window");
	}

	void runScript(GoogleMaps map) {
		map.setCenter(new Point(-122.1419, 37.4419));
		map.setZoomLevel(4);
		map.showInfoWindow(map.getCenter(), "Hello, world");
	}
}
