/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.sample;

import jp.sf.mapswidgets.Bounds;
import jp.sf.mapswidgets.GoogleMaps;
import jp.sf.mapswidgets.Marker;
import jp.sf.mapswidgets.MarkerAdapter;
import jp.sf.mapswidgets.Point;

public final class MarkerInfoWindow extends GoogleDocumentSample {
	public static void main(String [] arguments) {
		new MarkerInfoWindow().run();
	}
	
	private MarkerInfoWindow() {
		super("Display Info Window Above Markers", "http://www.google.com/apis/maps/documentation/#Display_Info_Windows_Above_Markers");
	}

	void runScript(GoogleMaps map) {
		// Center the map on Palo Alto.
        map.setSmallMapControlVisible(true);
        map.setMapTypeControlVisible(true);
        map.setCenter(new Point(-122.1419, 37.4419));
        map.setZoomLevel(4);

        // Create one of our tiny markers at the given point.
        // see createMarker(Point, Icon) method

        // Add 10 random markers in the map viewport.
        Bounds bounds = map.getMapBounds();
        double width = bounds.getMaxX() - bounds.getMinX();
        double height = bounds.getMaxY() - bounds.getMinY();
        for (int i = 0; i < 10; i++) {
        	Point point = new Point(bounds.getMinX() + width * Math.random(), bounds.getMinY() + height * Math.random());

        	Marker marker = createMarker(point, i + 1);
        	map.addOverlay(marker);
        }
	}
	
	// Create a marker whose info window displays the given number.
	private Marker createMarker(Point point, int number) {
        final Marker marker = new Marker(point);

        // Show this marker's index in the info window when it is clicked.
        final String html = "Marker #<b>" + number + "</b>";
        marker.addMarkerListener(new MarkerAdapter() {
			public void clicked() {
				marker.showInfoWindow(html);
			}
		});
		return marker;
	}
}
