/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.sample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import jp.sf.mapswidgets.Bounds;
import jp.sf.mapswidgets.GoogleMaps;
import jp.sf.mapswidgets.Marker;
import jp.sf.mapswidgets.Point;
import jp.sf.mapswidgets.Polyline;


public final class Overlay extends GoogleDocumentSample {
	public static void main(String [] arguments) {
		new Overlay().run();
	}
	
	private Overlay() {
		super("The Basics", "http://www.google.com/apis/maps/documentation/#The_Basics");
	}

	void runScript(GoogleMaps map) {
		// Center the map on Palo Alto.
		map.setSmallMapControlVisible(true);
		map.setMapTypeControlVisible(true);
		map.setCenter(new Point(-122.1419, 37.4419));
		map.setZoomLevel(4);
		
		// Add 10 random markers in the map viewport using the default icon.
		Bounds bounds = map.getMapBounds();
		double width = bounds.getMaxX() - bounds.getMinX();
		double height = bounds.getMaxY() - bounds.getMinY();
		for (int i = 0; i < 10; i++) {
			Point point = new Point(bounds.getMinX() + width * Math.random(), bounds.getMinY() + height * Math.random());
			Marker marker = new Marker(point);
			map.addOverlay(marker);
		}

		// Add a polyline with 4 random points. Sort the points by
		// longitude so that the line does not intersect itself.
		List<Point> points = new ArrayList<Point>();
		for (int i = 0; i < 5; i++) {
			points.add(new Point(bounds.getMinX() + width * Math.random(), bounds.getMinY() + height * Math.random()));
		}
		Collections.sort(points, new Comparator<Point>() {
			public int compare(Point p1, Point p2) {
				return (int)Math.signum(p1.getX() - p2.getX());
			}
		});
		map.addOverlay(new Polyline(points.toArray(new Point[0])));
	}
}
