/*******************************************************************************
 * Copyright (c) 2005 Koji Hisano <hisano@users.sourceforge.net>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.mapswidgets.tools;

import jp.sf.mapswidgets.GoogleMaps;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScriptTester {
	public static void main(String [] arguments) {
		Display display = new Display();
		final Shell shell = new Shell(display);
		shell.setText("Script Tester");
		shell.setLayout(new FillLayout());

		final SashForm sashForm = new SashForm(shell, SWT.HORIZONTAL);

		final GoogleMaps browser = new GoogleMaps(sashForm, SWT.NONE);

		final Composite composite = new Composite(sashForm, SWT.NONE);
		composite.setLayout(new GridLayout());

		final Label label = new Label(composite, SWT.NONE);
		label.setText("&Script:");

		final Text text = new Text(composite, SWT.V_SCROLL | SWT.MULTI | SWT.H_SCROLL);
		text.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));

		final Button button = new Button(composite, SWT.PUSH);
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
			}
		});
		button.setText(" &Run Script In Left Browser");
		button.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				boolean result = browser.execute(text.getText());
				if (!result) {
					MessageBox message = new MessageBox(shell, SWT.OK | SWT.ICON_ERROR);
					message.setText("Invalid Script");
					message.setMessage("Running a script failed.\nPlease, check your script.");
					message.open();
				}
			}
		});

		sashForm.setWeights(new int[] { 1, 1 });

		browser.setSmallMapControlVisible(true);

        shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}
}
