package com.marevol.utils.portlet.faces;

import java.io.IOException;
import java.util.Map;

import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class ActionResponseUtil extends PortletResponseUtil
{
    public static ActionResponse getActionResponse()
    {
        PortletResponse portletResponse = getPortletResponse();
        if (portletResponse == null)
        {
            throw new IllegalStateException("Faces Response is not PortletResponse.");
        }
        if (portletResponse instanceof ActionResponse)
        {
            return (ActionResponse) portletResponse;
        }

        return null;
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionResponse#sendRedirect(java.lang.String)
     */
    public static void sendRedirect(String arg0) throws IOException
    {
        ActionResponse actionResponse = getActionResponse();
        if (actionResponse == null)
        {
            throw new IllegalStateException("Faces Response is not ActionResponse.");
        }
        actionResponse.sendRedirect(arg0);
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionResponse#setPortletMode(javax.portlet.PortletMode)
     */
    public static void setPortletMode(PortletMode arg0) throws PortletModeException
    {
        ActionResponse actionResponse = getActionResponse();
        if (actionResponse == null)
        {
            throw new IllegalStateException("Faces Response is not ActionResponse.");
        }
        actionResponse.setPortletMode(arg0);
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionResponse#setRenderParameter(java.lang.String, java.lang.String)
     */
    public static void setRenderParameter(String arg0, String arg1)
    {
        ActionResponse actionResponse = getActionResponse();
        if (actionResponse == null)
        {
            throw new IllegalStateException("Faces Response is not ActionResponse.");
        }
        actionResponse.setRenderParameter(arg0, arg1);
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionResponse#setRenderParameter(java.lang.String, java.lang.String[])
     */
    public static void setRenderParameter(String arg0, String[] arg1)
    {
        ActionResponse actionResponse = getActionResponse();
        if (actionResponse == null)
        {
            throw new IllegalStateException("Faces Response is not ActionResponse.");
        }
        actionResponse.setRenderParameter(arg0, arg1);
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionResponse#setRenderParameters(java.util.Map)
     */
    public static void setRenderParameters(Map arg0)
    {
        ActionResponse actionResponse = getActionResponse();
        if (actionResponse == null)
        {
            throw new IllegalStateException("Faces Response is not ActionResponse.");
        }
        actionResponse.setRenderParameters(arg0);
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionResponse#setWindowState(javax.portlet.WindowState)
     */
    public static void setWindowState(WindowState arg0) throws WindowStateException
    {
        ActionResponse actionResponse = getActionResponse();
        if (actionResponse == null)
        {
            throw new IllegalStateException("Faces Response is not ActionResponse.");
        }
        actionResponse.setWindowState(arg0);
    }

}
