/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marevol.utils.ynd.search.model.v1.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cache
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(Cache.class);

    private String url;

    private String size;

    /**
     * @return Returns the size.
     */
    public String getSize()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getSize() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getSize() - end");
        }
        return size;
    }

    /**
     * @param size The size to set.
     */
    public void setSize(String size)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setSize(Integer) - start");
        }

        this.size = size;

        if (log.isDebugEnabled())
        {
            log.debug("setSize(Integer) - end");
        }
    }

    /**
     * @return Returns the url.
     */
    public String getUrl()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getUrl() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getUrl() - end");
        }
        return url;
    }

    /**
     * @param url The url to set.
     */
    public void setUrl(String url)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUrl(String) - start");
        }

        this.url = url;

        if (log.isDebugEnabled())
        {
            log.debug("setUrl(String) - end");
        }
    }
}
