/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marevol.utils.ynd.search.model.v1.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Result
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(Result.class);

    private String title;

    private String summary;

    private String url;

    private String clickUrl;

    private String modificationDate;

    private String mimeType;

    private Cache cache;

    /**
     * @return Returns the cache.
     */
    public Cache getCache()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getCache() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getCache() - end");
        }
        return cache;
    }

    /**
     * @param cache The cache to set.
     */
    public void setCache(Cache cache)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setCache(Cache) - start");
        }

        this.cache = cache;

        if (log.isDebugEnabled())
        {
            log.debug("setCache(Cache) - end");
        }
    }

    /**
     * @return Returns the clickUrl.
     */
    public String getClickUrl()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getClickUrl() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getClickUrl() - end");
        }
        return clickUrl;
    }

    /**
     * @param clickUrl The clickUrl to set.
     */
    public void setClickUrl(String clickUrl)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setClickUrl(String) - start");
        }

        this.clickUrl = clickUrl;

        if (log.isDebugEnabled())
        {
            log.debug("setClickUrl(String) - end");
        }
    }

    /**
     * @return Returns the mimeType.
     */
    public String getMimeType()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getMimeType() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getMimeType() - end");
        }
        return mimeType;
    }

    /**
     * @param mimeType The mimeType to set.
     */
    public void setMimeType(String mimeType)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setMimeType(String) - start");
        }

        this.mimeType = mimeType;

        if (log.isDebugEnabled())
        {
            log.debug("setMimeType(String) - end");
        }
    }

    /**
     * @return Returns the modificationDate.
     */
    public String getModificationDate()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getModificationDate() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getModificationDate() - end");
        }
        return modificationDate;
    }

    /**
     * @param modificationDate The modificationDate to set.
     */
    public void setModificationDate(String modificationDate)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setModificationDate(Integer) - start");
        }

        this.modificationDate = modificationDate;

        if (log.isDebugEnabled())
        {
            log.debug("setModificationDate(Integer) - end");
        }
    }

    /**
     * @return Returns the summary.
     */
    public String getSummary()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getSummary() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getSummary() - end");
        }
        return summary;
    }

    /**
     * @param summary The summary to set.
     */
    public void setSummary(String summary)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setSummary(String) - start");
        }

        this.summary = summary;

        if (log.isDebugEnabled())
        {
            log.debug("setSummary(String) - end");
        }
    }

    /**
     * @return Returns the title.
     */
    public String getTitle()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitle() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitle() - end");
        }
        return title;
    }

    /**
     * @param title The title to set.
     */
    public void setTitle(String title)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitle(String) - start");
        }

        this.title = title;

        if (log.isDebugEnabled())
        {
            log.debug("setTitle(String) - end");
        }
    }

    /**
     * @return Returns the url.
     */
    public String getUrl()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getUrl() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getUrl() - end");
        }
        return url;
    }

    /**
     * @param url The url to set.
     */
    public void setUrl(String url)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUrl(String) - start");
        }

        this.url = url;

        if (log.isDebugEnabled())
        {
            log.debug("setUrl(String) - end");
        }
    }
}
