/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marevol.utils.ynd.search.model.v1.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;

public class ResultSet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(ResultSet.class);

    private ArrayList results = new ArrayList();

    private Integer totalResultsAvailable;

    private Integer totalResultsReturned;

    private Integer firstResultPosition;

    public void addResult(Result request)
    {
        if (log.isDebugEnabled())
        {
            log.debug("addResult(Result) - start");
        }

        results.add(request);

        if (log.isDebugEnabled())
        {
            log.debug("addResult(Result) - end");
        }
    }

    public Result[] getResults()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getResults() - start");
        }

        Result[] rslt = new Result[results.size()];
        for (int i = 0; i < results.size(); i++)
        {
            rslt[i] = (Result) results.get(i);
        }

        if (log.isDebugEnabled())
        {
            log.debug("getResults() - end");
        }
        return rslt;
    }

    public void setResults(Result[] rslt)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setResults(Result[]) - start");
        }

        for (int i = 0; i < rslt.length; i++)
        {
            this.results.add(rslt[i]);
        }

        if (log.isDebugEnabled())
        {
            log.debug("setResults(Result[]) - end");
        }
    }

    /**
     * @return Returns the firstResultPosition.
     */
    public Integer getFirstResultPosition()
    {
        return firstResultPosition;
    }

    /**
     * @param firstResultPosition The firstResultPosition to set.
     */
    public void setFirstResultPosition(Integer firstResultPosition)
    {
        this.firstResultPosition = firstResultPosition;
    }

    /**
     * @return Returns the totalResultsAvailable.
     */
    public Integer getTotalResultsAvailable()
    {
        return totalResultsAvailable;
    }

    /**
     * @param totalResultsAvailable The totalResultsAvailable to set.
     */
    public void setTotalResultsAvailable(Integer totalResultsAvailable)
    {
        this.totalResultsAvailable = totalResultsAvailable;
    }

    /**
     * @return Returns the totalResultsReturned.
     */
    public Integer getTotalResultsReturned()
    {
        return totalResultsReturned;
    }

    /**
     * @param totalResultsReturned The totalResultsReturned to set.
     */
    public void setTotalResultsReturned(Integer totalResultsReturned)
    {
        this.totalResultsReturned = totalResultsReturned;
    }

}
