/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marevol.utils.ynd.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.ynd.AbstractTestCase;
import com.marevol.utils.ynd.search.model.v1.web.Result;
import com.marevol.utils.ynd.search.model.v1.web.ResultSet;

public class WebSearchTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(WebSearchTest.class);

    public static Long testId = null;

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUp() - start");
        }

        // TODO Auto-generated method stub
        super.setUp();

        if (log.isDebugEnabled())
        {
            log.debug("setUp() - end");
        }
    }

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public WebSearchTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        if (log.isDebugEnabled())
        {
            log.debug("suite() - start");
        }

        TestSuite suite = new TestSuite();
        suite.addTest(new WebSearchTest("loadWebSearchResponse"));

        if (log.isDebugEnabled())
        {
            log.debug("suite() - end");
        }
        return suite;
    }

    public void loadWebSearchResponse()
    {
        File testFile = new File(getTestFile("src/test/resources/apiv1/result.xml"));
        WebSearch yws = new WebSearch();
        try
        {
            ResultSet resultSet = yws.load(new FileInputStream(testFile));
            assertEquals(resultSet.getFirstResultPosition().intValue(), 1);
            assertEquals(resultSet.getTotalResultsAvailable().intValue(), 79000000);
            assertEquals(resultSet.getTotalResultsReturned().intValue(), 2);

            if (log.isDebugEnabled())
            {
                log.debug("loadResult() -  : resultSet.getFirstResultPosition()=" + resultSet.getFirstResultPosition());
                log.debug("loadResult() -  : resultSet.getTotalResultsAvailable()="
                        + resultSet.getTotalResultsAvailable());
                log.debug("loadResult() -  : resultSet.getTotalResultsReturned()="
                        + resultSet.getTotalResultsReturned());
            }

            Result[] results = resultSet.getResults();
            for (int i = 0; i < results.length; i++)
            {
                log.debug("loadResult() -  : results[" + i + "].getClickUrl()=" + results[i].getClickUrl());
                log.debug("loadResult() -  : results[" + i + "].getMimeType()=" + results[i].getMimeType());
                log.debug("loadResult() -  : results[" + i + "].getSummary()=" + results[i].getSummary());
                log.debug("loadResult() -  : results[" + i + "].getTitle()=" + results[i].getTitle());
                log.debug("loadResult() -  : results[" + i + "].getUrl()=" + results[i].getUrl());
                log.debug("loadResult() -  : results[" + i + "].getCache().getUrl()=" + results[i].getCache().getUrl());
                log.debug("loadResult() -  : results[" + i + "].getCache().getSize()="
                        + results[i].getCache().getSize());
                log.debug("loadResult() -  : results[" + i + "].getModificationDate()="
                        + results[i].getModificationDate());
            }

            assertEquals(
                    results[0].getClickUrl(),
                    "http://wrs.search.yahoo.co.jp/S=96857362/K=%E6%B2%96%E7%B8%84/v=2/XP=yws/SID=w/l=WS1/R=1/H=1/IPC=jp/SHE=0//SIG=11fhm3q11/EXP=1135033270/*-http%3A//www.pref.okinawa.jp/");
            assertEquals(results[0].getMimeType(), "text/html");
            assertEquals(results[0].getSummary(), "沖縄県のホームページです。 ... 文字>を大きくするには ・沖縄の概況 ・沖縄県のシンボル ・広報・広聴 ...");
            assertEquals(results[0].getTitle(), "沖縄県");
            assertEquals(results[0].getUrl(), "http://www.pref.okinawa.jp/");
            assertEquals(
                    results[0].getCache().getUrl(),
                    "http://wrs.search.yahoo.co.jp/S=96857362/K=%E6%B2%96%E7%B8%84/v=2/XP=yws/SID=w/l=WS5/R=1//SIG=15s7dlsr3/EXP=1135033270/*-http%3A//cache.yahoofs.jp/search/cache?ei=UTF-8&eo=UTF-8&ac=0&n=2&b=1&va=%E6%B2%96%E7%B8%84&vm=r&u=www.pref.okinawa.jp/&w=%E6%B2%96%E7%B8%84&d=HRjQyeDiL8xo&icp=1&.intl=jp");
            assertEquals(results[0].getCache().getSize(), "53359");
            assertEquals(results[0].getModificationDate(), "1134399600");
            assertEquals(
                    results[1].getClickUrl(),
                    "http://wrs.search.yahoo.co.jp/S=96857362/K=%E6%B2%96%E7%B8%84/v=2/XP=yws/SID=w/l=WS1/R=2/H=1/IPC=jp/SHE=0//SIG=11fo9m4e8/EXP=1135033270/*-http%3A//www.okinawainfo.net/");
            assertEquals(results[1].getMimeType(), "text/html");
            assertEquals(
                    results[1].getSummary(),
                    "沖縄観光や沖縄ツアー、沖縄旅行の総合情報をお届け。沖縄のホテル、沖縄のビーチ、食事のお薦めランク、沖縄>の旅行記、沖縄情報掲示板など。沖縄に関するベースサイトに利用... 沖縄観光と沖縄旅行 沖縄情報ＩＭＡ サイト内情報案内 Yahoo Google Goo Infoseek ...");
            assertEquals(results[1].getTitle(), "沖縄観光:沖縄情報ＩＭＡ");
            assertEquals(results[1].getUrl(), "http://www.okinawainfo.net/");
            assertEquals(
                    results[1].getCache().getUrl(),
                    "http://wrs.search.yahoo.co.jp/S=96857362/K=%E6%B2%96%E7%B8%84/v=2/XP=yws/SID=w/l=WS5/R=2//SIG=15sdbogn2/EXP=1135033270/*-http%3A//cache.yahoofs.jp/search/cache?ei=UTF-8&eo=UTF-8&ac=0&n=2&b=1&va=%E6%B2%96%E7%B8%84&vm=r&u=www.okinawainfo.net/&w=%E6%B2%96%E7%B8%84&d=DG84lODiL83k&icp=1&.intl=jp");
            assertEquals(results[1].getCache().getSize(), "25253");
            assertEquals(results[1].getModificationDate(), "1134054000");

        }
        catch (FileNotFoundException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
