/*
 * Decompiled with CFR 0.152.
 */
package com.marevol.utils.ynd.search;

import com.marevol.utils.ynd.search.model.v1.web.ResultSet;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class WebSearch {
    private static final Log log = LogFactory.getLog((Class)(class$com$marevol$utils$ynd$search$WebSearch == null ? (class$com$marevol$utils$ynd$search$WebSearch = WebSearch.class$("com.marevol.utils.ynd.search.WebSearch")) : class$com$marevol$utils$ynd$search$WebSearch));
    private String webSearchServiceUrl;
    static /* synthetic */ Class class$com$marevol$utils$ynd$search$WebSearch;
    static /* synthetic */ Class class$com$marevol$utils$ynd$search$model$v1$web$ResultSet;

    public WebSearch() {
        this("http://api.search.yahoo.co.jp/WebSearchService/V1/webSearch");
    }

    public WebSearch(String url) {
        this.webSearchServiceUrl = url;
    }

    public ResultSet search(String appid, String query, int results, int start) throws IOException {
        return this.search(appid, query, "all", results, start, "any", true, true, null, null, null);
    }

    public ResultSet search(String appid, String query, String type, int results, int start, String format, boolean adultOk, boolean similarOk, String language, String country, String site) throws IOException {
        if (query == null) {
            return null;
        }
        StringBuffer url = new StringBuffer(this.webSearchServiceUrl);
        url.append("?appid=");
        url.append(appid);
        url.append("&query=");
        try {
            url.append(URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Unsupported Encoding Exception", (Throwable)e);
            url.append(query);
        }
        if (type != null) {
            url.append("&type=");
            url.append(type);
        }
        url.append("&results=");
        url.append(results);
        url.append("&start=");
        url.append(start);
        if (format != null) {
            url.append("&format=");
            url.append(format);
        }
        if (adultOk) {
            url.append("&adult_ok=1");
        } else {
            url.append("&adult_ok=0");
        }
        if (similarOk) {
            url.append("&similar_ok=1");
        } else {
            url.append("&similar_ok=0");
        }
        if (language != null) {
            url.append("&language=");
            url.append(language);
        }
        if (country != null) {
            url.append("&country=");
            url.append(country);
        }
        if (site != null) {
            url.append("&site=");
            url.append(site);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("search(String, String...) -  : url=" + url.toString()));
        }
        URL ywsUrl = new URL(url.toString());
        URLConnection con = ywsUrl.openConnection();
        return this.load(con.getInputStream());
    }

    public ResultSet load(InputStream is) {
        BindingConfiguration config = new BindingConfiguration();
        config.setMapIDs(false);
        ResultSet resultSet = null;
        BeanReader reader = new BeanReader();
        try {
            reader.registerBeanClass(class$com$marevol$utils$ynd$search$model$v1$web$ResultSet == null ? (class$com$marevol$utils$ynd$search$model$v1$web$ResultSet = WebSearch.class$("com.marevol.utils.ynd.search.model.v1.web.ResultSet")) : class$com$marevol$utils$ynd$search$model$v1$web$ResultSet);
            resultSet = (ResultSet)reader.parse((Reader)new InputStreamReader(is, "UTF-8"));
        }
        catch (IntrospectionException e) {
            log.error((Object)("Introspection Exception occurs." + e.toString()));
        }
        catch (IOException e) {
            log.error((Object)("I/O Exception occurs." + e.toString()));
        }
        catch (SAXException e) {
            log.error((Object)("SAX Exception occurs." + e.toString()));
        }
        return resultSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

