/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marevol.utils.logparser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class LogEntry
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(LogEntry.class);

    HashMap entryMap;

    SimpleDateFormat dateFormat;

    public LogEntry()
    {
        entryMap = new HashMap();
        dateFormat = new SimpleDateFormat();
    }

    public void setDateFormatPattern(String pattern)
    {
        dateFormat = new SimpleDateFormat(pattern);
    }

    public void put(String key, String value)
    {
        entryMap.put(key, value);
    }

    public String get(String key)
    {
        String returnString = (String) entryMap.get(key);
        return returnString;
    }

    public String getString(String key)
    {
        return get(key);
    }

    public Integer getInteger(String key) throws LogParserException
    {
        try
        {
            return new Integer(Integer.parseInt(get(key)));
        }
        catch (NumberFormatException e)
        {
            log.warn("Invalid format: " + get(key), e);
            throw new LogParserException("Invalid format: " + get(key), e);
        }
    }

    public int getInt(String key) throws LogParserException
    {
        try
        {
            return Integer.parseInt(get(key));
        }
        catch (NumberFormatException e)
        {
            log.warn("Invalid format: " + get(key), e);
            throw new LogParserException("Invalid format: " + get(key), e);
        }
    }

    public Date getDate(String key) throws LogParserException
    {
        try
        {
            return dateFormat.parse(get(key));
        }
        catch (ParseException e)
        {
            log.warn("Invalid date format pattern: " + get(key), e);
            throw new LogParserException("Invalid date format pattern: " + get(key), e);
        }
    }

    public String toString()
    {
        StringBuffer buf = new StringBuffer();
        Iterator ite = entryMap.keySet().iterator();
        while (ite.hasNext())
        {
            String key = (String) ite.next();
            buf.append(key + "=" + get(key) + "\n");
        }
        String returnString = buf.toString();
        return returnString;
    }
}
