package com.marevol.utils.logparser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogParserFactory
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(LogParserFactory.class);

    private static final String DEFAULT_LOG_PARSER = "com.marevol.utils.logparser.DefaultLogParser";

    public static LogParser getInstance(String className)
    {
        if (log.isDebugEnabled())
        {
            log.debug("getInstance(String) - start");
        }

        try
        {
            Class clazz = Class.forName(className);
            if (clazz != null)
            {
                Object obj = clazz.newInstance();
                if (obj instanceof LogParser)
                {
                    LogParser returnLogParser = (LogParser) obj;
                    if (log.isDebugEnabled())
                    {
                        log.debug("getInstance(String) - end");
                    }
                    return returnLogParser;
                }
            }
        }
        catch (ClassNotFoundException e)
        {
            log.error(e);
        }
        catch (InstantiationException e)
        {
            log.error(e);
        }
        catch (IllegalAccessException e)
        {
            log.error(e);
        }
        
        // Default Log Parser
        if (!className.equals(DEFAULT_LOG_PARSER))
        {
            LogParser returnLogParser = getInstance(DEFAULT_LOG_PARSER);
            if (log.isDebugEnabled())
            {
                log.debug("getInstance(String) - end");
            }
            return returnLogParser;
        }
        

        if (log.isDebugEnabled())
        {
            log.debug("getInstance(String) - end");
        }
        return null;
    }

}
