/*
 * Decompiled with CFR 0.152.
 */
package com.marevol.utils.logparser;

import com.marevol.utils.logparser.LogEntry;
import com.marevol.utils.logparser.LogParser;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultLogParser
implements LogParser {
    private static final Log log = LogFactory.getLog((Class)(class$com$marevol$utils$logparser$LogParser == null ? (class$com$marevol$utils$logparser$LogParser = DefaultLogParser.class$("com.marevol.utils.logparser.LogParser")) : class$com$marevol$utils$logparser$LogParser));
    private String format;
    private ArrayList codeIndexList;
    private ArrayList codeList;
    private ArrayList codeSeparatorList;
    private int startIndex;
    static /* synthetic */ Class class$com$marevol$utils$logparser$LogParser;

    public void setFormat(String format) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setFormat(String) - start format=" + format));
        }
        this.format = format;
        this.codeIndexList = new ArrayList();
        this.codeList = new ArrayList();
        this.codeSeparatorList = new ArrayList();
        int index = format.indexOf("%");
        while (index >= 0) {
            try {
                this.codeList.add(format.substring(index, index + 2));
                this.codeIndexList.add(new Integer(index));
            }
            catch (IndexOutOfBoundsException e) {
                log.error((Object)"Invalid log format.", (Throwable)e);
            }
            int newIndex = format.indexOf("%", index + 2);
            try {
                if (newIndex >= 0) {
                    this.codeSeparatorList.add(format.substring(index + 2, newIndex));
                } else {
                    this.codeSeparatorList.add(format.substring(index + 2));
                }
            }
            catch (IndexOutOfBoundsException e) {
                log.error((Object)"Index is out of bound.", (Throwable)e);
            }
            index = newIndex;
        }
        if (log.isDebugEnabled()) {
            int i;
            for (i = 0; i < this.codeIndexList.size(); ++i) {
                log.debug((Object)("setFormat(String) - i=" + i + ", codeIndexList.get(i)=" + this.codeIndexList.get(i)));
            }
            for (i = 0; i < this.codeList.size(); ++i) {
                log.debug((Object)("setFormat(String) - i=" + i + ", codeList.get(i)=" + this.codeList.get(i)));
            }
            for (i = 0; i < this.codeSeparatorList.size(); ++i) {
                log.debug((Object)("setFormat(String) - i=" + i + ", codeSeparatorList.get(i)='" + this.codeSeparatorList.get(i) + "'"));
            }
            log.debug((Object)"setFormat(String) - end");
        }
    }

    public String getFormat() {
        return this.format;
    }

    public LogEntry parse(String logEntry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse(String) -  : logEntry=" + logEntry));
        }
        LogEntry entry = new LogEntry();
        int start = (Integer)this.codeIndexList.get(0);
        for (int i = 0; i < this.codeIndexList.size(); ++i) {
            String separator = (String)this.codeSeparatorList.get(i);
            int end = logEntry.indexOf(separator, start);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parse(String) -  : start=" + start + ", end=" + end));
            }
            if (end >= 0) {
                try {
                    if (separator != null && !separator.equals("")) {
                        entry.put((String)this.codeList.get(i), logEntry.substring(start, end));
                    } else {
                        entry.put((String)this.codeList.get(i), logEntry.substring(start));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    log.error((Object)"Index is out of bound.", (Throwable)e);
                }
            }
            start = end + separator.length();
        }
        return entry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

