/*
 * Decompiled with CFR 0.152.
 */
package com.marevol.utils.logparser;

import com.marevol.utils.logparser.LogParserException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogEntry {
    private static final Log log = LogFactory.getLog((Class)(class$com$marevol$utils$logparser$LogEntry == null ? (class$com$marevol$utils$logparser$LogEntry = LogEntry.class$("com.marevol.utils.logparser.LogEntry")) : class$com$marevol$utils$logparser$LogEntry));
    HashMap entryMap = new HashMap();
    SimpleDateFormat dateFormat = new SimpleDateFormat();
    static /* synthetic */ Class class$com$marevol$utils$logparser$LogEntry;

    public void setDateFormatPattern(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public void put(String key, String value) {
        this.entryMap.put(key, value);
    }

    public String get(String key) {
        String returnString = (String)this.entryMap.get(key);
        return returnString;
    }

    public String getString(String key) {
        return this.get(key);
    }

    public Integer getInteger(String key) throws LogParserException {
        try {
            return new Integer(Integer.parseInt(this.get(key)));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid format: " + this.get(key)), (Throwable)e);
            throw new LogParserException("Invalid format: " + this.get(key), e);
        }
    }

    public int getInt(String key) throws LogParserException {
        try {
            return Integer.parseInt(this.get(key));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid format: " + this.get(key)), (Throwable)e);
            throw new LogParserException("Invalid format: " + this.get(key), e);
        }
    }

    public Date getDate(String key) throws LogParserException {
        try {
            return this.dateFormat.parse(this.get(key));
        }
        catch (ParseException e) {
            log.warn((Object)("Invalid date format pattern: " + this.get(key)), (Throwable)e);
            throw new LogParserException("Invalid date format pattern: " + this.get(key), e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator ite = this.entryMap.keySet().iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            buf.append(key + "=" + this.get(key) + "\n");
        }
        String returnString = buf.toString();
        return returnString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

