package com.marevol.utils.seasar.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import com.marevol.utils.seasar.framework.container.ContainerConstants;

public class S2PortletFilter implements PortletFilter
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(S2PortletFilter.class);

    public void init(PortletFilterConfig filterConfig) throws PortletException
    {
        if (log.isDebugEnabled())
        {
            log.debug("init(PortletFilterConfig) - start");
        }

        String configPath = filterConfig.getInitParameter(ContainerConstants.S2CONTAINER_CONFIG_PATH);
        if (log.isDebugEnabled())
        {
            log.debug("init(PortletFilterConfig) -  : configPath=" + configPath);
        }

        if (configPath != null)
        {
            SingletonS2ContainerFactory.setConfigPath(configPath);
        }
        SingletonS2ContainerFactory.init();

        if (log.isDebugEnabled())
        {
            log.debug("init(PortletFilterConfig) - end");
        }
    }

    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - start");
        }

        chain.renderFilter(request, response);

        if (log.isDebugEnabled())
        {
            log.debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - end");
        }
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("processActionFilter(ActionRequest, ActionResponse, PortletFilterChain) - start");
        }

        chain.processActionFilter(request, response);

        if (log.isDebugEnabled())
        {
            log.debug("processActionFilter(ActionRequest, ActionResponse, PortletFilterChain) - end");
        }
    }

    public void destroy()
    {
        if (log.isDebugEnabled())
        {
            log.debug("destroy() - start");
        }

        SingletonS2ContainerFactory.destroy();

        if (log.isDebugEnabled())
        {
            log.debug("destroy() - end");
        }
    }

}
