package com.marevol.utils.seasar.framework.container.filter;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.SimpleComponentDef;
import org.seasar.framework.exception.EmptyRuntimeException;

import com.marevol.utils.seasar.framework.container.ContainerConstants;
import com.marevol.utils.seasar.framework.container.impl.PortletRequestComponentDef;
import com.marevol.utils.seasar.framework.container.impl.PortletResponseComponentDef;

public class S2ContainerPortletFilter implements PortletFilter
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(S2ContainerPortletFilter.class);

    public void init(PortletFilterConfig filterConfig) throws PortletException
    {
        if (log.isDebugEnabled())
        {
            log.debug("init(PortletFilterConfig) - start");
        }

        try
        {
            S2Container container = SingletonS2ContainerFactory.getContainer();

            container.register(new PortletRequestComponentDef());
            container.register(new PortletResponseComponentDef());
            container.register(new SimpleComponentDef(filterConfig.getPortletConfig(), PortletConfig.class,
                    ContainerConstants.PORTLET_CONFIG_NAME));
            container.register(new SimpleComponentDef(filterConfig.getPortletConfig().getPortletContext(),
                    PortletContext.class, ContainerConstants.PORTLET_CONTEXT_NAME));

        }
        catch (EmptyRuntimeException e)
        {
            log.error("S2Container is not configured.", e);
            throw new PortletException("S2Container is not configured.", e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("init(PortletFilterConfig) - end");
        }
    }

    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - start");
        }

        S2Container container = SingletonS2ContainerFactory.getContainer();

        setPortletRequestInComponentDefs(container, request);
        setPortletResponseInComponentDefs(container, response);

        chain.renderFilter(request, response);

        setPortletRequestInComponentDefs(container, null);
        setPortletResponseInComponentDefs(container, null);

        if (log.isDebugEnabled())
        {
            log.debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - end");
        }
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("processActionFilter(ActionRequest, ActionResponse, PortletFilterChain) - start");
        }

        S2Container container = SingletonS2ContainerFactory.getContainer();

        setPortletRequestInComponentDefs(container, request);
        setPortletResponseInComponentDefs(container, response);

        chain.processActionFilter(request, response);

        setPortletRequestInComponentDefs(container, null);
        setPortletResponseInComponentDefs(container, null);

        if (log.isDebugEnabled())
        {
            log.debug("processActionFilter(ActionRequest, ActionResponse, PortletFilterChain) - end");
        }
    }

    public void destroy()
    {
        if (log.isDebugEnabled())
        {
            log.debug("destroy() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("destroy() - end");
        }
    }

    private void setPortletRequestInComponentDefs(S2Container container, PortletRequest request)
    {
        ComponentDef[] componentDefs = container.findComponentDefs(PortletRequest.class);
        for (int i = 0; i < componentDefs.length; i++)
        {
            if (componentDefs[i] instanceof PortletRequestComponentDef)
            {
                ((PortletRequestComponentDef) componentDefs[i]).setPortletRequest(request);
            }
        }
    }

    private void setPortletResponseInComponentDefs(S2Container container, PortletResponse response)
    {
        ComponentDef[] componentDefs = container.findComponentDefs(PortletResponse.class);
        for (int i = 0; i < componentDefs.length; i++)
        {
            if (componentDefs[i] instanceof PortletResponseComponentDef)
            {
                ((PortletResponseComponentDef) componentDefs[i]).setPortletResponse(response);
            }
        }
    }

}
