package com.marevol.utils.seasar.framework.container.impl;

import org.seasar.framework.container.impl.SimpleComponentDef;

public class ThreadLocalSimpleComponentDef extends SimpleComponentDef
{
    private ThreadLocal threadLocalObject;

    public ThreadLocalSimpleComponentDef(Class componentClass)
    {
        this(null, componentClass, null);
    }

    public ThreadLocalSimpleComponentDef(Object component)
    {
        this(component, component.getClass());
    }

    public ThreadLocalSimpleComponentDef(Object component, Class componentClass)
    {
        this(component, componentClass, null);
    }

    public ThreadLocalSimpleComponentDef(Object component, String componentName)
    {
        this(component, component.getClass(), componentName);
    }

    public ThreadLocalSimpleComponentDef(Object component, Class componentClass, String componentName)
    {
        super(component, componentClass, componentName);
        threadLocalObject = new ThreadLocal();
    }

    public Object getThreadLocalObject()
    {
        return threadLocalObject.get();
    }

    public void setThreadLocalObject(Object obj)
    {
        threadLocalObject.set(obj);
    }
}
