package com.marevol.utils.seasar.hibernate3.filter;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class OpenSessionInViewPortletFilter implements PortletFilter
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(OpenSessionInViewPortletFilter.class);

    /* (non-Javadoc)
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#init(org.apache.portals.bridges.portletfilter.PortletFilterConfig)
     */
    public void init(PortletFilterConfig filterConfig) throws PortletException
    {
        if (log.isDebugEnabled())
        {
            log.debug("init(PortletFilterConfig) - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("init(PortletFilterConfig) - end");
        }
    }

    /* (non-Javadoc)
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#processActionFilter(javax.portlet.ActionRequest, javax.portlet.ActionResponse, org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("processActionFilter(ActionRequest, ActionResponse, PortletFilterChain) - start");
        }

        S2Container container = SingletonS2ContainerFactory.getContainer();
        PortletFilterChainTx chainProxy = (PortletFilterChainTx) container.getComponent(PortletFilterChainTx.class);
        chainProxy.processActionFilter(request, response, chain);

        if (log.isDebugEnabled())
        {
            log.debug("processActionFilter(ActionRequest, ActionResponse, PortletFilterChain) - end");
        }
    }

    /* (non-Javadoc)
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#renderFilter(javax.portlet.RenderRequest, javax.portlet.RenderResponse, org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - start");
        }

        S2Container container = SingletonS2ContainerFactory.getContainer();
        PortletFilterChainTx chainProxy = (PortletFilterChainTx) container.getComponent(PortletFilterChainTx.class);
        chainProxy.renderFilter(request, response, chain);

        if (log.isDebugEnabled())
        {
            log.debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - end");
        }
    }

    public void destroy()
    {

    }
}
