package com.marevol.utils.seasar.hibernate3.filter;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.hibernate.Session;
import org.seasar.hibernate3.S2SessionFactory;

public class PortletFilterChainTxImpl implements PortletFilterChainTx
{

    private S2SessionFactory sessionFactory_;

    private String requestAttributeName_ = "S2Session";

    public PortletFilterChainTxImpl(S2SessionFactory sessionFactory)
    {
        sessionFactory_ = sessionFactory;
    }

    public void setRequestAttributeName(String requestAttributeName)
    {
        requestAttributeName_ = requestAttributeName;
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.seasar.hibernate3.filter.PortletFilterChainTx#processActionFilter(javax.portlet.ActionRequest, javax.portlet.ActionResponse, org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        Session session = sessionFactory_.getSession();
        request.setAttribute(requestAttributeName_, session);

        chain.processActionFilter(request, response);

        session.close();
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.seasar.hibernate3.filter.PortletFilterChainTx#renderFilter(javax.portlet.RenderRequest, javax.portlet.RenderResponse, org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain)
            throws PortletException, IOException
    {
        Session session = sessionFactory_.getSession();
        request.setAttribute(requestAttributeName_, session);

        chain.renderFilter(request, response);

        session.close();
    }
}
