package com.marevol.utils.hibernate.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.hibernate3.S2SessionFactory;

public class S2HibernateDataModel extends DataModel
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(S2HibernateDataModel.class);

    /**
     * Get Hibernate Session from S2Container.
     * 
     * @return
     */
    private Session getSession()
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        if (container == null)
        {
            log.error("S2Container is null. Check the configuration for S2Container.");
            throw new RuntimeException("S2Container is null. Check the configuration for S2Container.");
        }
        S2SessionFactory s2SessionFactory = (S2SessionFactory) container.getComponent(S2SessionFactory.class);
        if (s2SessionFactory == null)
        {
            log.error("S2SessionFactory is null. Check the configuration for S2Container.");
            throw new RuntimeException("S2SessionFactory is null. Check the configuration for S2Container.");
        }
        Session session = s2SessionFactory.getSession();
        if (session == null)
        {
            log.error("Cannot create Hibernate Session from S2SessionFactory.");
            throw new RuntimeException("Cannot create Hibernate Session from S2SessionFactory.");
        }

        return session;
    }

    private HibernateDataModel dataModel;

    public S2HibernateDataModel(String hSql, Object[] params)
    {
        dataModel = new HibernateDataModel(getSession(), hSql, params);
    }

    public S2HibernateDataModel(String hSql, Object[] params, Type[] types)
    {
        dataModel = new HibernateDataModel(getSession(), hSql, params);
    }

    /* (non-Javadoc)
     * @see javax.faces.model.DataModel#addDataModelListener(javax.faces.model.DataModelListener)
     */
    public void addDataModelListener(DataModelListener arg0)
    {
        dataModel.addDataModelListener(arg0);
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj)
    {
        return dataModel.equals(obj);
    }

    /* (non-Javadoc)
     * @see javax.faces.model.DataModel#getDataModelListeners()
     */
    public DataModelListener[] getDataModelListeners()
    {
        return dataModel.getDataModelListeners();
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#getRowCount()
     */
    public int getRowCount()
    {
        return dataModel.getRowCount();
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#getRowData()
     */
    public Object getRowData()
    {
        return dataModel.getRowData();
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#getRowIndex()
     */
    public int getRowIndex()
    {
        return dataModel.getRowIndex();
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#getWrappedData()
     */
    public Object getWrappedData()
    {
        return dataModel.getWrappedData();
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        return dataModel.hashCode();
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#isRowAvailable()
     */
    public boolean isRowAvailable()
    {
        return dataModel.isRowAvailable();
    }

    /* (non-Javadoc)
     * @see javax.faces.model.DataModel#removeDataModelListener(javax.faces.model.DataModelListener)
     */
    public void removeDataModelListener(DataModelListener arg0)
    {
        dataModel.removeDataModelListener(arg0);
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#setRowCount(int)
     */
    public void setRowCount(int count)
    {
        dataModel.setRowCount(count);
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#setRowIndex(int)
     */
    public void setRowIndex(int rowIndex)
    {
        dataModel.setRowIndex(rowIndex);
    }

    /* (non-Javadoc)
     * @see com.marevol.utils.hibernate.faces.model.HibernateDataModel#setWrappedData(java.lang.Object)
     */
    public void setWrappedData(Object data)
    {
        dataModel.setWrappedData(data);
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return dataModel.toString();
    }
}
