package com.marevol.utils.portlet.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import javax.portlet.PortletRequest;
import javax.portlet.ActionRequest;

public class ActionRequestUtil extends PortletRequestUtil
{
    public static ActionRequest getActionRequest()
    {
        PortletRequest portletRequest = getPortletRequest();
        if (portletRequest == null)
        {
            throw new IllegalStateException("Faces Request is not PortletRequest.");
        }
        if (portletRequest instanceof ActionRequest)
        {
            return (ActionRequest) portletRequest;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionRequest#getCharacterEncoding()
     */
    public static String getCharacterEncoding()
    {
        ActionRequest actionRequest = getActionRequest();
        if (actionRequest == null)
        {
            throw new IllegalStateException("Faces Request is not ActionRequest.");
        }

        return actionRequest.getCharacterEncoding();
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionRequest#getContentLength()
     */
    public static int getContentLength()
    {
        ActionRequest actionRequest = getActionRequest();
        if (actionRequest == null)
        {
            throw new IllegalStateException("Faces Request is not ActionRequest.");
        }

        return actionRequest.getContentLength();
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionRequest#getContentType()
     */
    public static String getContentType()
    {
        ActionRequest actionRequest = getActionRequest();
        if (actionRequest == null)
        {
            throw new IllegalStateException("Faces Request is not ActionRequest.");
        }

        return actionRequest.getContentType();
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionRequest#getPortletInputStream()
     */
    public static InputStream getPortletInputStream() throws IOException
    {
        ActionRequest actionRequest = getActionRequest();
        if (actionRequest == null)
        {
            throw new IllegalStateException("Faces Request is not ActionRequest.");
        }

        return actionRequest.getPortletInputStream();
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionRequest#getReader()
     */
    public static BufferedReader getReader() throws UnsupportedEncodingException, IOException
    {
        ActionRequest actionRequest = getActionRequest();
        if (actionRequest == null)
        {
            throw new IllegalStateException("Faces Request is not ActionRequest.");
        }

        return actionRequest.getReader();
    }

    /* (non-Javadoc)
     * @see javax.portlet.ActionRequest#setCharacterEncoding(java.lang.String)
     */
    public static void setCharacterEncoding(String arg0) throws UnsupportedEncodingException
    {
        ActionRequest actionRequest = getActionRequest();
        if (actionRequest == null)
        {
            throw new IllegalStateException("Faces Request is not ActionRequest.");
        }

        actionRequest.setCharacterEncoding(arg0);
    }
}
