package com.marevol.utils.portlet.faces;

import javax.faces.context.FacesContext;
import javax.portlet.PortletResponse;

public class PortletResponseUtil
{
    public static PortletResponse getPortletResponse()
    {
        if (FacesContext.getCurrentInstance().getExternalContext().getResponse() instanceof PortletResponse)
        {
            return (PortletResponse) FacesContext.getCurrentInstance().getExternalContext().getResponse();
        }
        return null;
    }

    /* (non-Javadoc)
     * @see javax.portlet.PortletResponse#addProperty(java.lang.String, java.lang.String)
     */
    public static void addProperty(String arg0, String arg1)
    {
        PortletResponse portletResponse = getPortletResponse();
        if (portletResponse == null)
        {
            throw new IllegalStateException("Faces Response is not PortletResponse.");
        }
        portletResponse.addProperty(arg0, arg1);
    }

    /* (non-Javadoc)
     * @see javax.portlet.PortletResponse#encodeURL(java.lang.String)
     */
    public static String encodeURL(String arg0)
    {
        PortletResponse portletResponse = getPortletResponse();
        if (portletResponse == null)
        {
            throw new IllegalStateException("Faces Response is not PortletResponse.");
        }
        return portletResponse.encodeURL(arg0);
    }

    /* (non-Javadoc)
     * @see javax.portlet.PortletResponse#setProperty(java.lang.String, java.lang.String)
     */
    public static void setProperty(String arg0, String arg1)
    {
        PortletResponse portletResponse = getPortletResponse();
        if (portletResponse == null)
        {
            throw new IllegalStateException("Faces Response is not PortletResponse.");
        }
        portletResponse.setProperty(arg0, arg1);
    }

}
