package com.marevol.utils.portlet.faces;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;

import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;

public class RenderResponseUtil extends PortletResponseUtil
{
    public static RenderResponse getRenderResponse()
    {
        PortletResponse portletResponse = getPortletResponse();
        if (portletResponse == null)
        {
            throw new IllegalStateException("Faces Response is not PortletResponse.");
        }
        if (portletResponse instanceof RenderResponse)
        {
            return (RenderResponse) portletResponse;
        }

        return null;
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#createActionURL()
     */
    public static PortletURL createActionURL()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.createActionURL();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#createRenderURL()
     */
    public static PortletURL createRenderURL()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.createRenderURL();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#flushBuffer()
     */
    public static void flushBuffer() throws IOException
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        renderResponse.flushBuffer();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#getBufferSize()
     */
    public static int getBufferSize()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.getBufferSize();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#getCharacterEncoding()
     */
    public static String getCharacterEncoding()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.getCharacterEncoding();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#getContentType()
     */
    public static String getContentType()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.getContentType();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#getLocale()
     */
    public static Locale getLocale()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.getLocale();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#getNamespace()
     */
    public static String getNamespace()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.getNamespace();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#getPortletOutputStream()
     */
    public static OutputStream getPortletOutputStream() throws IOException
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.getPortletOutputStream();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#getWriter()
     */
    public static PrintWriter getWriter() throws IOException
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.getWriter();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#isCommitted()
     */
    public static boolean isCommitted()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        return renderResponse.isCommitted();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#reset()
     */
    public static void reset()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        renderResponse.reset();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#resetBuffer()
     */
    public static void resetBuffer()
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        renderResponse.resetBuffer();
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#setBufferSize(int)
     */
    public static void setBufferSize(int arg0)
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        renderResponse.setBufferSize(arg0);
    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#setContentType(java.lang.String)
     */
    public static void setContentType(String arg0)
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        renderResponse.setContentType(arg0);

    }

    /* (non-Javadoc)
     * @see javax.portlet.RenderResponse#setTitle(java.lang.String)
     */
    public static void setTitle(String arg0)
    {
        RenderResponse renderResponse = getRenderResponse();
        if (renderResponse == null)
        {
            throw new IllegalStateException("Faces Response is not RenderResponse.");
        }
        renderResponse.setTitle(arg0);
    }

}
