package com.marevol.utils.portlet.faces.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author shinsuke
 * @deprecated
 */
public class FacesPortletBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(FacesPortletBean.class);

    /* Example:
     * 
     *  portlet-msg-status style:
     *   Progress: 80%
     *  portlet-msg-info style:
     *   Info about
     *  portlet-msg-error style:
     *   Portal not available
     *  portlet-msg-alert style:
     *   Time out occurred, try again later
     *  portlet-msg-success style:
     *   Operation completed successfully
     *   
     *  In JSP file:
     *   
     *   <h:outputText value="#{titleViewPortlet.msgSuccess}" styleClass="portlet-msg-success" escape="false" rendered="#{titleViewPortlet.isMsgSuccess}"/>
     *   <h:outputText value="#{titleViewPortlet.msgError}" styleClass="portlet-msg-error" escape="false" rendered="#{titleViewPortlet.isMsgError}"/>
     *   <h:outputText value="#{titleViewPortlet.msgAlert}" styleClass="portlet-msg-alert" escape="false" rendered="#{titleViewPortlet.isMsgAlert}"/>
     *   <h:outputText value="#{titleViewPortlet.msgInfo}" styleClass="portlet-msg-info" escape="false" rendered="#{titleViewPortlet.isMsgInfo}"/>
     */

    /** provides a message for portlet-msg-info style */
    protected String msgInfo;

    /** provides a message for portlet-msg-error style */
    protected String msgError;

    /** provides a message for portlet-msg-alert style */
    protected String msgAlert;

    /** provides a message for portlet-msg-success style */
    protected String msgSuccess;

    public FacesPortletBean()
    {
        msgInfo = "";
        msgError = "";
        msgAlert = "";
        msgSuccess = "";
    }

    /**
     * @return Returns the msgInfo.
     */
    public String getMsgInfo()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getMsgInfo() - start");
        }

        StringBuffer buf = new StringBuffer(msgInfo);
        if (msgInfo.length() > 0)
        {
            buf.append("<br/>");
        }
        msgInfo = "";
        String returnString = buf.toString();
        if (log.isDebugEnabled())
        {
            log.debug("getMsgInfo() - end");
        }
        return returnString;
    }

    /**
     * @param msgInfo The msgInfo to set.
     */
    public void setMsgInfo(String message)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setMsgInfo(String) - start");
        }

        this.msgInfo = message;

        if (log.isDebugEnabled())
        {
            log.debug("setMsgInfo(String) - end");
        }
    }

    public void addMsgInfo(String msg)
    {
        if (log.isDebugEnabled())
        {
            log.debug("addMsgInfo(String) - start");
        }

        msgInfo = msgInfo + msg;

        if (log.isDebugEnabled())
        {
            log.debug("addMsgInfo(String) - end");
        }
    }

    public Boolean getIsMsgInfo()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getIsMsgInfo() - start");
        }

        if (msgInfo != null && !msgInfo.equals(""))
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgInfo() - end");
            }
            return Boolean.TRUE;
        }
        else
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgInfo() - end");
            }
            return Boolean.FALSE;
        }
    }

    /**
     * @return Returns the msgAlert.
     */
    public String getMsgAlert()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getMsgAlert() - start");
        }

        StringBuffer buf = new StringBuffer(msgAlert);
        if (msgAlert.length() > 0)
        {
            buf.append("<br/>");
        }
        msgAlert = "";
        String returnString = buf.toString();
        if (log.isDebugEnabled())
        {
            log.debug("getMsgAlert() - end");
        }
        return returnString;
    }

    /**
     * @param msgAlert The msgAlert to set.
     */
    public void setMsgAlert(String msgAlert)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setMsgAlert(String) - start");
        }

        this.msgAlert = msgAlert;

        if (log.isDebugEnabled())
        {
            log.debug("setMsgAlert(String) - end");
        }
    }

    public void addMsgAlert(String msg)
    {
        if (log.isDebugEnabled())
        {
            log.debug("addMsgAlert(String) - start");
        }

        msgAlert = msgAlert + msg;

        if (log.isDebugEnabled())
        {
            log.debug("addMsgAlert(String) - end");
        }
    }

    public Boolean getIsMsgAlert()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getIsMsgAlert() - start");
        }

        if (msgAlert != null && !msgAlert.equals(""))
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgAlert() - end");
            }
            return Boolean.TRUE;
        }
        else
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgAlert() - end");
            }
            return Boolean.FALSE;
        }
    }

    /**
     * @return Returns the msgError.
     */
    public String getMsgError()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getMsgError() - start");
        }

        StringBuffer buf = new StringBuffer(msgError);
        if (msgError.length() > 0)
        {
            buf.append("<br/>");
        }
        msgError = "";
        String returnString = buf.toString();
        if (log.isDebugEnabled())
        {
            log.debug("getMsgError() - end");
        }
        return returnString;
    }

    /**
     * @param msgError The msgError to set.
     */
    public void setMsgError(String msgError)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setMsgError(String) - start");
        }

        this.msgError = msgError;

        if (log.isDebugEnabled())
        {
            log.debug("setMsgError(String) - end");
        }
    }

    public void addMsgError(String msg)
    {
        if (log.isDebugEnabled())
        {
            log.debug("addMsgError(String) - start");
        }

        msgError = msgError + msg;

        if (log.isDebugEnabled())
        {
            log.debug("addMsgError(String) - end");
        }
    }

    public Boolean getIsMsgError()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getIsMsgError() - start");
        }

        if (msgError != null && !msgError.equals(""))
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgError() - end");
            }
            return Boolean.TRUE;
        }
        else
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgError() - end");
            }
            return Boolean.FALSE;
        }
    }

    /**
     * @return Returns the msgSuccess.
     */
    public String getMsgSuccess()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getMsgSuccess() - start");
        }

        StringBuffer buf = new StringBuffer(msgSuccess);
        if (msgSuccess.length() > 0)
        {
            buf.append("<br/>");
        }
        msgSuccess = "";
        String returnString = buf.toString();
        if (log.isDebugEnabled())
        {
            log.debug("getMsgSuccess() - end");
        }
        return returnString;
    }

    /**
     * @param msgSuccess The msgSuccess to set.
     */
    public void setMsgSuccess(String msgSuccess)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setMsgSuccess(String) - start");
        }

        this.msgSuccess = msgSuccess;

        if (log.isDebugEnabled())
        {
            log.debug("setMsgSuccess(String) - end");
        }
    }

    public void addMsgSuccess(String msg)
    {
        if (log.isDebugEnabled())
        {
            log.debug("addMsgSuccess(String) - start");
        }

        msgSuccess = msgSuccess + msg;

        if (log.isDebugEnabled())
        {
            log.debug("addMsgSuccess(String) - end");
        }
    }

    public Boolean getIsMsgSuccess()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getIsMsgSuccess() - start");
        }

        if (msgSuccess != null && !msgSuccess.equals(""))
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgSuccess() - end");
            }
            return Boolean.TRUE;
        }
        else
        {
            if (log.isDebugEnabled())
            {
                log.debug("getIsMsgSuccess() - end");
            }
            return Boolean.FALSE;
        }
    }

}
