package com.marevol.utils.faces.application;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

public class FacesMessageUtil
{
    public static void addMessage(FacesMessage.Severity severity, java.lang.String summary, java.lang.String detail)
    {
        FacesMessage facesMessage = new FacesMessage(severity, summary, detail);

        FacesContext.getCurrentInstance().addMessage(null, facesMessage);
    }

    public static void addErrorMessage(java.lang.String summary, java.lang.String detail)
    {
        addMessage(FacesMessage.SEVERITY_ERROR, summary, detail);
    }

    public static void addErrorMessage(java.lang.String summary)
    {
        addErrorMessage(summary, null);
    }

    public static void addFatalMessage(java.lang.String summary, java.lang.String detail)
    {
        addMessage(FacesMessage.SEVERITY_FATAL, summary, detail);
    }

    public static void addFatalMessage(java.lang.String summary)
    {
        addFatalMessage(summary, null);
    }

    public static void addInfoMessage(java.lang.String summary, java.lang.String detail)
    {
        addMessage(FacesMessage.SEVERITY_INFO, summary, detail);
    }

    public static void addInfoMessage(java.lang.String summary)
    {
        addInfoMessage(summary, null);
    }

    public static void addWarnMessage(java.lang.String summary, java.lang.String detail)
    {
        addMessage(FacesMessage.SEVERITY_WARN, summary, detail);
    }

    public static void addWarnMessage(java.lang.String summary)
    {
        addWarnMessage(summary, null);
    }

}
