package com.marevol.utils.faces.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class DateFormatUtil
{
    public static String getLongFormattedDateTime(Date d)
    {
        return getFormattedDateTime(d, DateFormat.LONG, DateFormat.LONG);
    }

    public static String getMediumFormattedDateTime(Date d)
    {
        return getFormattedDateTime(d, DateFormat.MEDIUM, DateFormat.MEDIUM);
    }

    public static String getShortFormattedDateTime(Date d)
    {
        return getFormattedDateTime(d, DateFormat.SHORT, DateFormat.SHORT);
    }

    public static String getFormattedDateTime(Date d, int dateStyle, int timeStyle)

    {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        return df.format(d);
    }

    public static String getLongFormattedDate(Date d)
    {
        return getFormattedDate(d, DateFormat.LONG);
    }

    public static String getMediumFormattedDate(Date d)
    {
        return getFormattedDate(d, DateFormat.MEDIUM);
    }

    public static String getShortFormattedDate(Date d)
    {
        return getFormattedDate(d, DateFormat.SHORT);
    }

    public static String getFormattedDate(Date d, int dateStyle)
    {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
        return df.format(d);
    }

    public static String getLongFormattedTime(Date d)
    {
        return getFormattedTime(d, DateFormat.LONG);
    }

    public static String getMediumFormattedTime(Date d)
    {
        return getFormattedTime(d, DateFormat.MEDIUM);
    }

    public static String getShortFormattedTime(Date d)
    {
        return getFormattedTime(d, DateFormat.SHORT);
    }

    public static String getFormattedTime(Date d, int timeStyle)
    {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getTimeInstance(timeStyle, locale);
        return df.format(d);
    }
}
