/*
 * Decompiled with CFR 0.152.
 */
package com.marevol.utils.hibernate;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.stat.SessionStatistics;

public class HibernateUtil {
    private static Log log = LogFactory.getLog((Class)(class$com$marevol$utils$hibernate$HibernateUtil == null ? (class$com$marevol$utils$hibernate$HibernateUtil = HibernateUtil.class$("com.marevol.utils.hibernate.HibernateUtil")) : class$com$marevol$utils$hibernate$HibernateUtil));
    public static final String WEBAPP_ROOT = "\\$\\{webappRoot\\}";
    private static SessionFactory sessionFactory = null;
    public static final ThreadLocal session = new ThreadLocal();
    public static final ThreadLocal transaction = new ThreadLocal();
    static /* synthetic */ Class class$com$marevol$utils$hibernate$HibernateUtil;

    public static void init() {
        try {
            sessionFactory = new Configuration().configure().buildSessionFactory();
        }
        catch (Throwable ex) {
            log.error((Object)"Initial SessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static void init(PortletConfig portletConfig) {
        String webappRoot = portletConfig.getPortletContext().getRealPath("/");
        if (log.isDebugEnabled()) {
            log.debug((Object)("init(PortletConfig) -  : webappRoot=" + webappRoot));
        }
        webappRoot = webappRoot.replaceAll("\\\\", "\\\\\\\\\\\\\\\\");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(WEBAPP_ROOT, webappRoot);
        HibernateUtil.init(map);
    }

    public static void init(Map map) {
        Configuration config = new Configuration().configure();
        Enumeration<Object> e = config.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = config.getProperty(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("init(Map) -  : key=" + key + ", value=" + value));
            }
            Iterator ite = map.keySet().iterator();
            while (ite.hasNext()) {
                String keyword = (String)ite.next();
                if (!value.matches(".*" + keyword + ".*")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("init(Map) -  : key=" + key + ", value=" + value + ", keyword=" + keyword + ", val=" + map.get(keyword)));
                }
                value = value.replaceAll(keyword, (String)map.get(keyword));
                config.setProperty(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("init(Map) -  : REPLACED: key=" + key + ", value=" + value));
            }
            if (!key.equals("hibernate.connection.url") || !value.startsWith("jdbc:hsqldb:")) continue;
            value = value.replace('\\', '/');
            config.setProperty(key, value);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("init(Map) -  : REPLACED: key=" + key + ", value=" + value));
        }
        try {
            sessionFactory = config.buildSessionFactory();
        }
        catch (Throwable ex) {
            log.error((Object)"Initial SessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    private static SessionFactory getSessionFactoryInstance() {
        if (sessionFactory == null) {
            HibernateUtil.init();
        }
        return sessionFactory;
    }

    public static void openSession() {
        HibernateUtil.getCurrentSession();
    }

    public static Session getCurrentSession() {
        Session s = (Session)session.get();
        if (s == null) {
            s = HibernateUtil.getSessionFactoryInstance().openSession();
            session.set(s);
        }
        return s;
    }

    public static void closeSession() {
        Session s = (Session)session.get();
        if (s != null) {
            s.close();
        }
        session.set(null);
    }

    public static Transaction beginTransaction() {
        Transaction tx = (Transaction)transaction.get();
        if (tx == null) {
            tx = HibernateUtil.getCurrentSession().beginTransaction();
            transaction.set(tx);
        }
        return tx;
    }

    public static void commit() {
        Transaction tx = (Transaction)transaction.get();
        if (tx != null) {
            tx.commit();
        }
        transaction.set(null);
    }

    public static void rollback() {
        Transaction tx = (Transaction)transaction.get();
        if (tx != null) {
            tx.rollback();
        }
        transaction.set(null);
    }

    public static Serializable save(Object arg0) {
        return HibernateUtil.getCurrentSession().save(arg0);
    }

    public static Object load(Class arg0, Serializable arg1) {
        return HibernateUtil.getCurrentSession().load(arg0, arg1);
    }

    public static void cancelQuery() throws HibernateException {
        HibernateUtil.getCurrentSession().cancelQuery();
    }

    public static void clear() {
        HibernateUtil.getCurrentSession().clear();
    }

    public static Connection close() throws HibernateException {
        return HibernateUtil.getCurrentSession().close();
    }

    public static Connection connection() throws HibernateException {
        return HibernateUtil.getCurrentSession().connection();
    }

    public static boolean contains(Object arg0) {
        return HibernateUtil.getCurrentSession().contains(arg0);
    }

    public static Criteria createCriteria(Class arg0, String arg1) {
        return HibernateUtil.getCurrentSession().createCriteria(arg0, arg1);
    }

    public static Criteria createCriteria(Class arg0) {
        return HibernateUtil.getCurrentSession().createCriteria(arg0);
    }

    public static Criteria createCriteria(String arg0, String arg1) {
        return HibernateUtil.getCurrentSession().createCriteria(arg0, arg1);
    }

    public static Criteria createCriteria(String arg0) {
        return HibernateUtil.getCurrentSession().createCriteria(arg0);
    }

    public static Query createFilter(Object arg0, String arg1) throws HibernateException {
        return HibernateUtil.getCurrentSession().createFilter(arg0, arg1);
    }

    public static Query createQuery(String arg0) throws HibernateException {
        return HibernateUtil.getCurrentSession().createQuery(arg0);
    }

    public static SQLQuery createSQLQuery(String arg0) throws HibernateException {
        return HibernateUtil.getCurrentSession().createSQLQuery(arg0);
    }

    public static void delete(Object arg0) throws HibernateException {
        HibernateUtil.getCurrentSession().delete(arg0);
    }

    public static void disableFilter(String arg0) {
        HibernateUtil.getCurrentSession().disableFilter(arg0);
    }

    public static Connection disconnect() throws HibernateException {
        return HibernateUtil.getCurrentSession().disconnect();
    }

    public static Filter enableFilter(String arg0) {
        return HibernateUtil.getCurrentSession().enableFilter(arg0);
    }

    public static void evict(Object arg0) throws HibernateException {
        HibernateUtil.getCurrentSession().evict(arg0);
    }

    public static void flush() throws HibernateException {
        HibernateUtil.getCurrentSession().flush();
    }

    public static Object get(Class arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        return HibernateUtil.getCurrentSession().get(arg0, arg1, arg2);
    }

    public static Object get(Class arg0, Serializable arg1) throws HibernateException {
        return HibernateUtil.getCurrentSession().get(arg0, arg1);
    }

    public static Object get(String arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        return HibernateUtil.getCurrentSession().get(arg0, arg1, arg2);
    }

    public static Object get(String arg0, Serializable arg1) throws HibernateException {
        return HibernateUtil.getCurrentSession().get(arg0, arg1);
    }

    public static CacheMode getCacheMode() {
        return HibernateUtil.getCurrentSession().getCacheMode();
    }

    public static LockMode getCurrentLockMode(Object arg0) throws HibernateException {
        return HibernateUtil.getCurrentSession().getCurrentLockMode(arg0);
    }

    public static Filter getEnabledFilter(String arg0) {
        return HibernateUtil.getCurrentSession().getEnabledFilter(arg0);
    }

    public static EntityMode getEntityMode() {
        return HibernateUtil.getCurrentSession().getEntityMode();
    }

    public static String getEntityName(Object arg0) throws HibernateException {
        return HibernateUtil.getCurrentSession().getEntityName(arg0);
    }

    public static FlushMode getFlushMode() {
        return HibernateUtil.getCurrentSession().getFlushMode();
    }

    public static Serializable getIdentifier(Object arg0) throws HibernateException {
        return HibernateUtil.getCurrentSession().getIdentifier(arg0);
    }

    public static Query getNamedQuery(String arg0) throws HibernateException {
        return HibernateUtil.getCurrentSession().getNamedQuery(arg0);
    }

    public static Session getSession(EntityMode arg0) {
        return HibernateUtil.getCurrentSession().getSession(arg0);
    }

    public static SessionFactory getSessionFactory() {
        return HibernateUtil.getCurrentSession().getSessionFactory();
    }

    public static SessionStatistics getStatistics() {
        return HibernateUtil.getCurrentSession().getStatistics();
    }

    public static boolean isConnected() {
        return HibernateUtil.getCurrentSession().isConnected();
    }

    public static boolean isDirty() throws HibernateException {
        return HibernateUtil.getCurrentSession().isDirty();
    }

    public static boolean isOpen() {
        return HibernateUtil.getCurrentSession().isOpen();
    }

    public static Object load(Class arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        return HibernateUtil.getCurrentSession().load(arg0, arg1, arg2);
    }

    public static void load(Object arg0, Serializable arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().load(arg0, arg1);
    }

    public static Object load(String arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        return HibernateUtil.getCurrentSession().load(arg0, arg1, arg2);
    }

    public static Object load(String arg0, Serializable arg1) throws HibernateException {
        return HibernateUtil.getCurrentSession().load(arg0, arg1);
    }

    public static void lock(Object arg0, LockMode arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().lock(arg0, arg1);
    }

    public static void lock(String arg0, Object arg1, LockMode arg2) throws HibernateException {
        HibernateUtil.getCurrentSession().lock(arg0, arg1, arg2);
    }

    public static Object merge(Object arg0) throws HibernateException {
        return HibernateUtil.getCurrentSession().merge(arg0);
    }

    public static Object merge(String arg0, Object arg1) throws HibernateException {
        return HibernateUtil.getCurrentSession().merge(arg0, arg1);
    }

    public static void persist(Object arg0) throws HibernateException {
        HibernateUtil.getCurrentSession().persist(arg0);
    }

    public static void persist(String arg0, Object arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().persist(arg0, arg1);
    }

    public static void reconnect() throws HibernateException {
        HibernateUtil.getCurrentSession().reconnect();
    }

    public static void reconnect(Connection arg0) throws HibernateException {
        HibernateUtil.getCurrentSession().reconnect(arg0);
    }

    public static void refresh(Object arg0, LockMode arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().refresh(arg0, arg1);
    }

    public static void refresh(Object arg0) throws HibernateException {
        HibernateUtil.getCurrentSession().refresh(arg0);
    }

    public static void replicate(Object arg0, ReplicationMode arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().replicate(arg0, arg1);
    }

    public static void replicate(String arg0, Object arg1, ReplicationMode arg2) throws HibernateException {
        HibernateUtil.getCurrentSession().replicate(arg0, arg1, arg2);
    }

    public static void save(Object arg0, Serializable arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().save(arg0, arg1);
    }

    public static void save(String arg0, Object arg1, Serializable arg2) throws HibernateException {
        HibernateUtil.getCurrentSession().save(arg0, arg1, arg2);
    }

    public static Serializable save(String arg0, Object arg1) throws HibernateException {
        return HibernateUtil.getCurrentSession().save(arg0, arg1);
    }

    public static void saveOrUpdate(Object arg0) throws HibernateException {
        HibernateUtil.getCurrentSession().saveOrUpdate(arg0);
    }

    public static void saveOrUpdate(String arg0, Object arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().saveOrUpdate(arg0, arg1);
    }

    public static void setCacheMode(CacheMode arg0) {
        HibernateUtil.getCurrentSession().setCacheMode(arg0);
    }

    public static void setFlushMode(FlushMode arg0) {
        HibernateUtil.getCurrentSession().setFlushMode(arg0);
    }

    public static void update(Object arg0, Serializable arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().update(arg0, arg1);
    }

    public static void update(Object arg0) throws HibernateException {
        HibernateUtil.getCurrentSession().update(arg0);
    }

    public static void update(String arg0, Object arg1, Serializable arg2) throws HibernateException {
        HibernateUtil.getCurrentSession().update(arg0, arg1, arg2);
    }

    public static void update(String arg0, Object arg1) throws HibernateException {
        HibernateUtil.getCurrentSession().update(arg0, arg1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

