package com.marevol.utils.faces.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Locale;

import javax.faces.context.FacesContext;

public class LocaleUtil
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(LocaleUtil.class);

    public static Locale getLocale()
    {
        try
        {
            return FacesContext.getCurrentInstance().getViewRoot().getLocale();
        }
        catch (RuntimeException e)
        {
            log.error("FacesContext.getCurrentInstance().getViewRoot().getLocale() is invalid state.");
            return Locale.ENGLISH;
        }
    }
}
