/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.kaoriha.marimite.viewer.LimitDialog;
import org.kaoriha.marimite.viewer.Main;
import org.kaoriha.marimite.viewer.MessageResource;
import org.kaoriha.marimite.viewer.chart.Updater;
import org.kaoriha.marimite.viewer.dnd.PanePacker;
import org.kaoriha.marimite.viewer.pref.WindowLocator;

public class RootFrame
extends JFrame {
    private Timer refreshTimer = null;
    private long currentRefreshInterval;
    private JTextField connectAddressTextField;
    private JTextField connectionStatusTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JTextField mbeanDomainTextField;
    private JComboBox refreshIntervalComboBox;
    private JButton showChartButton;

    public RootFrame() {
        this.initComponents();
        this.refreshIntervalComboBox.setSelectedIndex(1);
        this.setConnectionStatus("\u672a\u63a5\u7d9a");
        this.connectAddressTextField.setText(Main.getServerAddress() + "/" + Main.getJndiName());
        this.mbeanDomainTextField.setText(Main.getJmxDomainName());
        this.setTitle(MessageResource.TitleBar.getRootFrame());
        new WindowLocator("RootFrame", this);
    }

    private void changeRefreshInterval() {
        long interval;
        int selected = this.refreshIntervalComboBox.getSelectedIndex();
        switch (selected) {
            case 0: {
                interval = 300L;
                break;
            }
            case 1: {
                interval = 1000L;
                break;
            }
            case 2: {
                interval = 3000L;
                break;
            }
            case 3: {
                interval = 10000L;
                break;
            }
            case 4: {
                this.refreshTimer.cancel();
                this.currentRefreshInterval = 0L;
                return;
            }
            default: {
                return;
            }
        }
        if (interval == this.currentRefreshInterval) {
            return;
        }
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
        this.refreshTimer = new Timer();
        this.refreshTimer.schedule((TimerTask)new RefreshRunner(), interval, interval);
        this.currentRefreshInterval = interval;
    }

    private void initComponents() {
        this.connectAddressTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.refreshIntervalComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.connectionStatusTextField = new JTextField();
        this.showChartButton = new JButton();
        this.jLabel5 = new JLabel();
        this.mbeanDomainTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.connectAddressTextField.setEditable(false);
        this.connectAddressTextField.setText("connectAddressTextField");
        this.jLabel1.setText("\u63a5\u7d9a\u5148");
        this.jLabel2.setText("\u66f4\u65b0\u9593\u9694");
        this.refreshIntervalComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0.3 sec", "1 sec", "3 sec", "10 sec", "Stop"}));
        this.refreshIntervalComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RootFrame.this.refreshIntervalComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel3.setText("\u63a5\u7d9a\u72b6\u614b");
        this.connectionStatusTextField.setEditable(false);
        this.connectionStatusTextField.setText("connectionStatusTextField");
        this.showChartButton.setText("\u672a\u8868\u793a\u30c1\u30e3\u30fc\u30c8\u3092\u8868\u793a");
        this.showChartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RootFrame.this.showChartButtonActionPerformed(evt);
            }
        });
        this.jLabel5.setText("MBean\u30c9\u30e1\u30a4\u30f3\u540d");
        this.mbeanDomainTextField.setEditable(false);
        this.mbeanDomainTextField.setText("mbeanDomainTextField");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectAddressTextField, -1, 322, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mbeanDomainTextField, -1, 277, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionStatusTextField, -1, 310, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshIntervalComboBox, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 110, Short.MAX_VALUE).addComponent(this.showChartButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.connectAddressTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.mbeanDomainTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.connectionStatusTextField, -2, -1, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refreshIntervalComboBox, -2, -1, -2).addComponent(this.showChartButton).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void refreshIntervalComboBoxItemStateChanged(ItemEvent evt) {
        this.changeRefreshInterval();
    }

    private void showChartButtonActionPerformed(ActionEvent evt) {
        new LimitDialog((Window)this).setVisible(true);
    }

    @Override
    public void dispose() {
        this.refreshTimer.cancel();
        PanePacker.suspend();
        WindowLocator.shutdown();
        super.dispose();
        System.exit(0);
    }

    public void setConnectionStatus(String connectionStatus) {
        this.connectionStatusTextField.setText(connectionStatus);
    }

    private static class RefreshRunner
    extends TimerTask {
        private RefreshRunner() {
        }

        @Override
        public void run() {
            Updater.updateAll();
        }
    }
}

