/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.pref;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.kaoriha.marimite.viewer.pref.ClientPreference;

public class WindowLocator {
    private static final Set<WindowLocator> INSTANCE_SET = new CopyOnWriteArraySet<WindowLocator>();
    private static final String LOCATION_MAP_KEY = "locationMap";
    private static ClientPreference PREF;
    private String key;
    private Window target;

    public static void init(String address, String path) {
        PREF = ClientPreference.getInstance(address, path);
    }

    public WindowLocator(String key, Window window) {
        this.key = key;
        this.target = window;
        window.setLocationByPlatform(true);
        this.loadLocation();
        INSTANCE_SET.add(this);
    }

    private static HashMap<String, Location> getLocationMap() {
        Object o = PREF.deserialize(LOCATION_MAP_KEY);
        if (o == null) {
            return new HashMap<String, Location>();
        }
        return new HashMap<String, Location>((Map)o);
    }

    private void loadLocation() {
        HashMap<String, Location> locationMap = WindowLocator.getLocationMap();
        if (locationMap.containsKey(this.key)) {
            Location l = (Location)locationMap.get(this.key);
            this.target.setSize(l.dimension);
            this.target.setLocation(l.point);
        }
    }

    public static void shutdown() {
        HashMap<String, Location> locationMap = new HashMap<String, Location>();
        for (WindowLocator dl : INSTANCE_SET) {
            locationMap.put(dl.key, new Location(dl.target.getSize(), dl.target.getLocation()));
        }
        try {
            PREF.serialize(LOCATION_MAP_KEY, locationMap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        INSTANCE_SET.clear();
    }

    public void dispose() {
        INSTANCE_SET.remove(this);
    }

    private static class Location
    implements Serializable {
        public Dimension dimension;
        public Point point;

        public Location() {
        }

        public Location(Dimension dimension, Point point) {
            this.dimension = dimension;
            this.point = point;
        }
    }
}

