/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.math.BigDecimal;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSDecimal
extends XSType {
    BigDecimal _maxInclusive = null;
    BigDecimal _maxExclusive = null;
    BigDecimal _minInclusive = null;
    BigDecimal _minExclusive = null;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;
    private static final JType jType = new JClass("java.math.BigDecimal");

    public XSDecimal() {
        super((short)16);
    }

    public String createFromJavaObjectCode(String variableName) {
        return "(java.math.BigDecimal)" + variableName;
    }

    public BigDecimal getMaxExclusive() {
        return this._maxExclusive;
    }

    public BigDecimal getMaxInclusive() {
        return this._maxInclusive;
    }

    public BigDecimal getMinExclusive() {
        return this._minExclusive;
    }

    public BigDecimal getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public int getFractionDigits() {
        return this._fractionDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(BigDecimal max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(BigDecimal max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(BigDecimal min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(BigDecimal min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFractionDigits(int fractionDig) {
        if (fractionDig < 0) {
            throw new IllegalArgumentException(this.getName() + ": the fractionDigits facet must be positive");
        }
        this._fractionDigits = fractionDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSDecimal.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("totalDigits".equals(name)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if (!"fractionDigits".equals(name)) continue;
            this.setFractionDigits(facet.toInt());
        }
    }

    public JType getJType() {
        return jType;
    }

    public String newInstanceCode() {
        String result = "new java.math.BigDecimal(0);";
        return result;
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        int fractionDigits;
        int totalDigits;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("DecimalValidator typeValidator = new DecimalValidator();");
        if (this.hasMinimum()) {
            BigDecimal min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(new java.math.BigDecimal(\"");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(new java.math.BigDecimal(\"");
            }
            jsc.append(min.toString() + "\")");
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            BigDecimal max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(new java.math.BigDecimal(\"");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(new java.math.BigDecimal(\"");
            }
            jsc.append(max.toString() + "\")");
            jsc.append(");");
        }
        if ((totalDigits = this.getTotalDigits()) != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        if ((fractionDigits = this.getFractionDigits()) != -1) {
            jsc.add("typeValidator.setFractionDigits(");
            jsc.append(Integer.toString(fractionDigits));
            jsc.append(");");
        }
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

