/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.maskat.framework.screendef.IComponentDef;

public class MaskatTextEditor
extends AbstractTextEditor
implements ISelectionListener {
    private String lastRevealedName = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        super.init(site, input);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        AbstractGraphicalEditPart ssG;
        Object model;
        StructuredSelection ss;
        if (selection instanceof StructuredSelection && (ss = (StructuredSelection)selection).getFirstElement() instanceof AbstractGraphicalEditPart && (model = (ssG = (AbstractGraphicalEditPart)ss.getFirstElement()).getModel()) instanceof IComponentDef) {
            try {
                String name = ((IComponentDef)model).getName();
                if (name.equals(this.lastRevealedName)) {
                    return;
                }
                this.lastRevealedName = name;
                IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(doc);
                if (finder.length() == 0) {
                    return;
                }
                IRegion region = finder.find(0, name, true, true, true, false);
                if (region != null) {
                    this.selectAndReveal(region.getOffset(), region.getLength());
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.maskat.ide.gef", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u691c\u7d22", (String)"\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u691c\u7d22\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (IStatus)status);
            }
        }
    }

    protected void setDocumentProvider(IEditorInput input) {
        super.setDocumentProvider(DocumentProviderRegistry.getDefault().getDocumentProvider(input));
    }
}

