/*
 * Copyright 2006 Mask@ Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
/**
 * JavaScriptIuWFNgRialtoIuWFNgWrapē̃C^[tF[X񋟂B
 */

function ObjWrapper(object){
  this.obj = object;
}

ObjWrapper.prototype.isMultiSelect = function(){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){ // [RialtoAPIˑ]
      case "grid":
        return this.obj.multiSelect; // [RialtoAPIˑ]
      case "treeview":
        return false; // treeview͌AIs\
      default:
        break;
    }
  }
  throw new MaskatError({name: "Type Error",
                         message: "̃IuWFNgɑ΂Ă̊֐͎sł܂B",
                         fileName: "objWrapper.js",
                         functionName: "ObjWrapper.prototype.isMultiSelect"});
}

ObjWrapper.prototype.isSingleDataObj = function(){
  if (maskat.isRialtoObj(this.obj)){
    // this.objRialtoIuWFNg
    switch (this.obj.type){  // [RialtoAPIˑ]
      case "label":
      case "text":
      case "combo":
      case "checkbox":
      case "radioGroup":
      case "codelib":
        return true;
      default:
        return false;
    }
  }
  else {
    // this.objJavaScriptIuWFNg
    return !maskat.isArray(this.obj);
  }
}

ObjWrapper.prototype.isMultiDataObj = function(){
  if (maskat.isRialtoObj(this.obj)){
    // this.objRialtoIuWFNg
    switch (this.obj.type){ // [RialtoAPIˑ]
      case "grid":
      case "treeview":
        return true;
      default:
        return false;
    }
  }
  else {
    // this.objJavaScriptIuWFNg
    return maskat.isArray(this.obj);  // TODO: 2zwɂH
  }
}


ObjWrapper.prototype.getSingleValue = function(){
  if (!this.isSingleDataObj()){
    throw new MaskatError({name: "Type Error",
                           message: "f[^^̃IuWFNgɑ΂Ă̊֐͎sł܂B",
                           fileName: "objWrapper.js",
                           functionName: "ObjWrapper.prototype.getSingleValue"});
  }
  else {
    if (maskat.isRialtoObj(this.obj)){
      switch (this.obj.type){
        case "label":
          return this.obj.text;  // [RialtoAPIˑ] getterAPIȂ̂ŒtextvpeBQ
        case "text":
          return this.obj.getValue();  // [RialtoAPIˑ] rialto.widget.Text.prototype.getValue
        case "combo":
          return this.obj.getSelValue();  // [RialtoAPIˑ] rialto.widget.Combo.prototype.getSelValue
        case "checkbox":
          // booleanlł͂ȂƂĕԂ
          return "" + this.obj.getCheck();  // [RialtoAPIˑ] rialto.widget.Checkbox.prototype.getCheck, rialto.widget.Radio.prototype.getCheck
        case "radioGroup":
          return this.obj.getSelValue();
        case "codelib":
          return this.obj.getValue();
        default:
          break;
      }
    }
    else{
      // JavaScriptIuWFNg
      return this.obj;
    }
  }
}

ObjWrapper.prototype.setSingleValue = function(val){
  if (!this.isSingleDataObj()){
    throw new MaskatError({name: "Type Error",
                           message: "f[^^̃IuWFNgɑ΂Ă̊֐͎sł܂B",
                           fileName: "objWrapper.js",
                           functionName: "ObjWrapper.prototype.setSingleValue"});
  }
  else {
    if (maskat.isRialtoObj(this.obj)){
      switch (this.obj.type){  // [RialtoAPIˑ]
        case "label":
          this.obj.setText(val);  // [RialtoAPIˑ] rialto.widget.Label.prototype.setText
          break;
        case "text":
          this.obj.setValue(val);  // [RialtoAPIˑ] rialto.widget.Text.prototype.setValue
          break;
        case "combo":
          this.obj.selWithValue(val);  // [RialtoAPIˑ] rialto.widget.Combo.prototype.selWithValue
          break;
        case "checkbox":
          if (val == "true"){
            this.obj.setCheck(true);  // [RialtoAPIˑ] rialto.widget.Checkbox.prototype.setCheck, rialto.widget.Radio.prototype.setCheck
          }
          else {
            this.obj.setCheck(false);  // [RialtoAPIˑ] rialto.widget.Checkbox.prototype.setCheck, rialto.widget.Radio.prototype.setCheck
          }
          break;
        case "radioGroup":
          this.obj.setSelValue(val);
          break;
      }
    }
    else{
      // TODO: JavaScriptIuWFNgւsetValue
      throw new Error("rialtoIuWFNgsetValuełȂB"+this.obj.base);
    }
  }
}

ObjWrapper.prototype.setMultiValue = function(val){
  if (!this.isMultiDataObj()){
    throw new MaskatError({name: "Type Error",
                           message: "Pf[^^̃IuWFNgɑ΂Ă̊֐͎sł܂B",
                           fileName: "objWrapper.js",
                           functionName: "ObjWrapper.prototype.setValue"});
  }
  else {
    if (maskat.isRialtoObj(this.obj)){
      switch (this.obj.type){  // [RialtoAPIˑ]
        case "grid":
          this.setGridValue(val);
          break;
        case "treeview":
          this.setTreeValue(val);
          break;
      }
    }
    else{
      // TODO: JavaScriptIuWFNgւsetValue
    }
  }
}


ObjWrapper.prototype.setTreeValue = function(val){
  try {
    // ݂̃c[̑SẴm[h폜
    if (this.obj.rootNode != null){  // [RialtoAPIˑ]
        this.obj.rootNode.remove();  // APIł̂v`FbN
        this.obj.rootNode = null;
    }

    for (var i = 0; i < val.length; i++){
      var parentName;
      if (!val[i]["PARENT"]){
        // [gm[h̏ꍇ
        parentName = this.obj.name;
      }
      else {
        parentName = val[i]["PARENT"];
      }
      eval(val[i]["NAME"] + "= " + this.obj.name + ".createAndAddNode(" + parentName + ".id,{name:'" + val[i]["NAME"] + "',text:'" + maskat.escapeDoubleQuote(val[i]["TEXT"]) + "',icon:'images/imTreeview/pict_synthetik_off.gif',icon2:'',open:true,reload:false,onclick:''});" );  // [RialtoAPIˑ]
      
      for (var key in val[i]){
        if (key.charAt(0) == "_"){
          if(!(eval(val[i]["NAME"] + ".maskatHiddenField"))){
            eval(val[i]["NAME"] + ".maskatHiddenField = new Object();");
          }
          eval(val[i]["NAME"] + ".maskatHiddenField['" + key + "'] = '" + val[i][key] + "';");
        }
      }
      
    }
  }
  catch (e){
    throw e;
  }
}

ObjWrapper.prototype.setGridValue = function(val){
  try {
    if (val.length==0){
        this.obj.deleteLines();
        return;
    }
    var gridJSStr = "[";
    for (var i = 0; i < val.length; i++){
      gridJSStr += "[";
      for (var j in val[i]){
        var colIndex = parseInt(j);
        if (!isNaN(colIndex) && colIndex < this.obj.NbreCol){  // [RialtoAPIˑ] GridIuWFNg̗
          gridJSStr += '"' + maskat.escapeDoubleQuote(val[i][j]) + '",';  // TODO: itemValue"\"ɕϊ
        }
      }
      gridJSStr = gridJSStr.substring(0, gridJSStr.length - 1);  // Ō','菜
      gridJSStr += "],";
    }
    gridJSStr = gridJSStr.substring(0, gridJSStr.length - 1);  // Ō','菜
    gridJSStr += "]";

    eval("this.obj.fillGrid(" + gridJSStr + ", 0, false)");
  }
  catch (e){
    throw e;
  }
}

ObjWrapper.prototype.getSelectedIndex = function(){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){ // [RialtoAPIˑ]
      case "grid":
        return this.obj.indLineClic; // [RialtoAPIˑ]
      case "treeview":
        if (this.obj.currentSelNode){
          return maskat.getTreeRowNumByName(this.obj, this.obj.currentSelNode.name);
        }
        else {
          return -1;
        }
      default:
        break;
    }
  }
  throw new MaskatError({name: "Type Error",
                         message: "̃IuWFNgɑ΂Ă̊֐͎sł܂B",  // TODO: ڍׂ
                         fileName: "objWrapper.js",
                         functionName: "ObjWrapper.prototype.getSelectedIndex"});
}


maskat.getTreeRowNumByName = function(treeview, name){
  if (!treeview.rootNode){
    return -1;
  }
  
  var treeNodeStack = new Array();
  treeNodeStack.push(treeview.rootNode);
  
  var rowNum = -1;
  
  while (treeNodeStack.length != 0){
    var treeNode = treeNodeStack.pop();
    rowNum++;
    if (treeNode.name == name){
      return rowNum;
    }
    else {
      if (treeNode.hasChild()){  // [RialtoAPIˑ]
        for (var i = treeNode.arrChildNode.length - 1; i >= 0 ; i--){
          treeNodeStack.push(treeNode.arrChildNode[i]);
        }
      }
    }
  }
  
  // ŏIIɌȂꍇ(肦Ȃ)
  return -1;
}


ObjWrapper.prototype.getSelectedIndexes = function(){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){ // [RialtoAPIˑ]
      case "grid":
        var indexArray = new Array();
        for (var i = 0; i < this.obj.tabData.length; i++){ // [RialtoAPIˑ]
          var lineData = this.obj.tabData[i]; // [RialtoAPIˑ]
          if (lineData.sel == true){ // [RialtoAPIˑ]
            indexArray.push(i);
          }
        }
        return indexArray;
      case "treeview":
        // TODO: 
      default:
        break;
    }
  }

  throw new MaskatError({name: "Type Error",
                         message: "̃IuWFNgɑ΂Ă̊֐͎sł܂B",  // TODO: ڍׂ
                         fileName: "objWrapper.js",
                         functionName: "ObjWrapper.prototype.getSelectedIndexes"});
}

ObjWrapper.prototype.getColNum = function(){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){ // [RialtoAPIˑ]
      case "grid":
        return this.obj.NbreCol;  // [RialtoAPIˑ]
      case "treeview":
        // TODO: ΏAPITB
      default:
        break;
    }
  }
  
  throw new MaskatError({name: "Type Error",
                         message: "̃IuWFNgɑ΂Ă̊֐͎sł܂B",  // TODO: ڍׂ
                         fileName: "objWrapper.js",
                         functionName: "ObjWrapper.prototype.getColLength"});
}

ObjWrapper.prototype.getRowNum = function(){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){ // [RialtoAPIˑ]
      case "grid":
        if (this.obj.tabData){ // [RialtoAPIˑ]
          return this.obj.tabData.length;  // [RialtoAPIˑ]
        }
        else {
          return 0;
        }
      case "treeview":
        return maskat.countDescendantTreeNode(this.obj);
      default:
        break;
    }
  }
  else if (maskat.isArray(this.obj)){
    return this.obj.length;
  }
  
  throw new MaskatError({name: "Type Error",
                         message: "̃IuWFNgɑ΂Ă̊֐͎sł܂B",  // TODO: ڍׂ
                         fileName: "objWrapper.js",
                         functionName: "ObjWrapper.prototype.getRowNum"});
}


maskat.countDescendantTreeNode = function(treeview){
  if (!treeview.rootNode){  // [RialtoAPIˑ]
    return 0;
  }

  var num = 0;
  var treeNodeArray = new Array();
  treeNodeArray.push(treeview.rootNode);  // [RialtoAPIˑ]

  while (treeNodeArray.length != 0){
    treeNode = treeNodeArray.shift();
    num++;
    if (treeNode.hasChild()){
      for (var i = 0; i < treeNode.arrChildNode.length; i++){  // [RialtoAPIˑ]
        treeNodeArray.push(treeNode.arrChildNode[i]);
      }
    }
  }
  return num;
}

ObjWrapper.prototype.getValueFromMultiData = function(row, col){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){ // [RialtoAPIˑ]
      case "grid":
        return this.obj.tabData[row][col];  // [RialtoAPIˑ]
      case "treeview":
        // row:s, col:fromkey(ID/TEXT/PARENT)
        var treeNode = maskat.findTreeNodeByRowNum(this.obj, row);  // fromkeyĂ΂̂ŃLbVׂ
        if (!treeNode){
          return null;
        }
        
        if (col.charAt(0) == "_"){
          if (!treeNode.maskatHiddenField){
            return "";
          }
          return treeNode.maskatHiddenField[col];
        }
        else{
          switch (col){
            case "NAME":
              return treeNode.name;
            case "TEXT":
              return treeNode.text;
            case "PARENT":
              if (treeNode.fatherNode){
                return treeNode.fatherNode.name;
              }
              else {
                return null;
              }
            default:
              throw new MaskatError({name: "EventXML Syntax Error",
                                     message: "TreeviewIuWFNgɑ΂fromkey'" + col + "'͖ΉłB",
                                     fileName: "objWrapper.js",
                                     functionName: "ObjWrapper.prototype.getValueFromMultiData"});
          }
        }
      default:
        break;
    }
  }
  else if (maskat.isArray(this.obj)){  // TODO: 2z`FbNH
    return this.obj[row][col];
  }
  else {
    throw new MaskatError({name: "Type Error",
                           message: "̃IuWFNgɑ΂Ă̊֐͎sł܂B",  // TODO: ڍׂ
                           fileName: "objWrapper.js",
                           functionName: "ObjWrapper.prototype.getValueFromMultiData"});
  }
}

maskat.findTreeNodeByRowNum = function(treeview, row){
  if (!treeview.rootNode || row == -1){
    return null;
  }
  
  var treeNodeStack = new Array();
  treeNodeStack.push(treeview.rootNode);

  var currentRow = -1;

  while (treeNodeStack.length != 0){
    var treeNode = treeNodeStack.pop();
    currentRow++;
    if (currentRow == row){
      return treeNode;
    }
    else {
      if (treeNode.hasChild()){  // [RialtoAPIˑ]
        for (var i = treeNode.arrChildNode.length - 1; i >= 0 ; i--){
          treeNodeStack.push(treeNode.arrChildNode[i]);
        }
      }
    }
  }

  return null;

}




ObjWrapper.prototype.isJSObj = function(){
  return !maskat.isRialtoObj(this.obj);  // RialtoȊÕCu𗘗pۂ͕ύX
}

ObjWrapper.prototype.clear = function(){
  if (maskat.isRialtoObj(this.obj)){
    switch (this.obj.type){
      case "label":
        this.obj.setText("");  // [RialtoAPIˑ] rialto.widget.Label.prototype.setText
        break;
      case "text":
        this.obj.setValue("");  // [RialtoAPIˑ] rialto.widget.Text.prototype.setValue
        break;
      case "checkbox":
        this.obj.setCheck(false);  // [RialtoAPIˑ] rialto.widget.Checkbox.prototype.setCheck, rialto.widget.Radio.prototype.setCheck
        break;
      case "radioGroup":
        this.obj.initRadio();
        break;
      case "grid":
        this.obj.initTab();
        break;
      case "treeview":
        if (this.obj.rootNode){  // [RialtoAPIˑ]
          this.obj.rootNode.remove();  // APIł̂v`FbN
          this.obj.rootNode = null;
        }
        break;
    }
  }
}

maskat.isRialtoObj = function(obj){
  return (obj && (typeof obj == "object") && (obj instanceof rialto.widget.AbstractComponent));
}

maskat.isArray = function(obj) {
  return (obj && (typeof obj == "object") && (obj.constructor == Array));
}

maskat.escapeDoubleQuote = function(str){
  return(str.split('"').join('\\"'));
}

//MdRV[}[
//Mdm[hf[^擾āAIuWFNgɓ
ObjWrapper.pluggableTeleConsumers={};

ObjWrapper.registerTeleConsumer = function(name,teleConsumer){
    ObjWrapper.pluggableTeleConsumers[name]=teleConsumer;
}

ObjWrapper.unregisterTeleConsumer = function(name){
    ObjWrapper.pluggableTeleConsumers[name]=null;
}

ObjWrapper.findTeleConsumer = function(teleType){
    return ObjWrapper.pluggableTeleConsumers[teleType];
}

//Mdmaker
//IuWFNgf[^擾āAMdgݗĂ
ObjWrapper.pluggableTeleMakers={};

ObjWrapper.registerTeleMaker = function(name,maker){
    ObjWrapper.pluggableTeleMakers[name]=maker;
}

ObjWrapper.unregisterTeleMaker = function(name){
    ObjWrapper.pluggableTeleMakers[name]=null;
}

ObjWrapper.findTeleMaker = function(teleType){
    return ObjWrapper.pluggableTeleMakers[teleType];
}
